/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import com.manticore.tools.xmldoclet.Parser;
import com.manticore.tools.xmldoclet.TypeUtils;
import com.manticore.tools.xmldoclet.xjc.AnnotationArgument;
import com.manticore.tools.xmldoclet.xjc.AnnotationInstance;
import com.manticore.tools.xmldoclet.xjc.ObjectFactory;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

class AnnotationParser {
    private static final Logger LOGGER = Logger.getLogger(AnnotationParser.class.getName());
    private final Parser parser;
    private final ObjectFactory objectFactory;

    AnnotationParser(Parser parser) {
        this.parser = parser;
        this.objectFactory = parser.objectFactory;
    }

    protected AnnotationInstance parse(Name programElement, AnnotationMirror annotationDesc) {
        AnnotationInstance annotationInstance = this.objectFactory.createAnnotationInstance();
        try {
            DeclaredType annotTypeInfo = annotationDesc.getAnnotationType();
            annotationInstance.setName(annotTypeInfo.asElement().getSimpleName().toString());
            annotationInstance.setQualified(TypeUtils.getQualifiedName(annotTypeInfo.asElement()));
        }
        catch (ClassCastException castException) {
            LOGGER.severe("Unable to obtain type data about an annotation found on: " + programElement);
            LOGGER.severe("Add to the classpath the class/jar that defines this annotation.");
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elementValuesPair : annotationDesc.getElementValues().entrySet()) {
            AnnotationArgument annotationArgumentNode = this.objectFactory.createAnnotationArgument();
            ExecutableElement annotationArgumentSetter = elementValuesPair.getKey();
            annotationArgumentNode.setName(annotationArgumentSetter.getSimpleName().toString());
            TypeMirror annotationArgumentType = AnnotationParser.getAnnotationArgumentType(annotationArgumentSetter);
            annotationArgumentNode.setType(this.parser.parseTypeInfo(annotationArgumentType));
            annotationArgumentNode.setPrimitive(annotationArgumentType.getKind().isPrimitive());
            annotationArgumentNode.setArray(TypeUtils.isArray(annotationArgumentType));
            AnnotationValue objValue = elementValuesPair.getValue();
            this.parseAnnotationArgValue(programElement, annotationArgumentNode, objValue);
            annotationInstance.getArgument().add(annotationArgumentNode);
        }
        return annotationInstance;
    }

    private void parseAnnotationArgValue(Name programElement, AnnotationArgument arg, Object argValue) {
        if (argValue instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)argValue;
            if (annotationValue.getValue() instanceof List) {
                List valueList = (List)annotationValue.getValue();
                this.parseAnnotationArgListValue(programElement, arg, valueList);
            } else {
                arg.getValue().add(annotationValue.getValue().toString());
            }
        } else if (argValue != null) {
            arg.getValue().add(argValue.toString());
        }
    }

    private void parseAnnotationArgListValue(Name programElement, AnnotationArgument arg, List<?> valueList) {
        for (Object value : valueList) {
            if (value instanceof AnnotationMirror) {
                AnnotationMirror annoDesc = (AnnotationMirror)value;
                arg.getAnnotation().add(this.parse(programElement, annoDesc));
                continue;
            }
            AnnotationValue annotationValue = (AnnotationValue)value;
            arg.getValue().add(annotationValue.getValue().toString());
        }
    }

    private static TypeMirror getAnnotationArgumentType(ExecutableElement annotationArgumentGetter) {
        TypeMirror annotationArgumentGetterType = annotationArgumentGetter.asType();
        return ((ExecutableType)annotationArgumentGetterType).getReturnType();
    }
}

