/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import jdk.javadoc.doclet.Doclet;

public class CustomOption
implements Doclet.Option {
    private final String description;
    private final String name;
    private final String parameters;
    private final BiPredicate<String, List<String>> argumentsProcessor;
    private final int argumentCount;

    public static CustomOption newOneArg(String name, String description, String argName, BiPredicate<String, List<String>> argumentsProcessor) {
        return new CustomOption(name, description, argName, 1, argumentsProcessor);
    }

    public static CustomOption newNoArgs(String name, String description, BiPredicate<String, List<String>> argumentsProcessor) {
        return new CustomOption(name, description, "", 0, argumentsProcessor);
    }

    private CustomOption(String name, String description, String argName, int argumentCount) {
        this(name, description, argName, argumentCount, (option, args) -> args.size() == argumentCount);
    }

    private CustomOption(String name, String description, String parameters, int argumentCount, BiPredicate<String, List<String>> argumentsProcessor) {
        this.name = CustomOption.addHyphenPrefix(name);
        this.description = description;
        this.parameters = Objects.requireNonNullElse(parameters, "");
        this.argumentCount = argumentCount;
        this.argumentsProcessor = argumentsProcessor;
    }

    static String addHyphenPrefix(String name) {
        return name.startsWith("-") ? name : "-" + name;
    }

    @Override
    public int getArgumentCount() {
        return this.argumentCount;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Doclet.Option.Kind getKind() {
        return Doclet.Option.Kind.STANDARD;
    }

    @Override
    public List<String> getNames() {
        return List.of(this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getParameters() {
        return this.parameters;
    }

    @Override
    public final boolean process(String option, List<String> arguments) {
        return this.argumentsProcessor.test(option, arguments);
    }
}

