/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import com.manticore.tools.xmldoclet.AnnotationParser;
import com.manticore.tools.xmldoclet.TypeUtils;
import com.manticore.tools.xmldoclet.xjc.Annotation;
import com.manticore.tools.xmldoclet.xjc.AnnotationElement;
import com.manticore.tools.xmldoclet.xjc.AnnotationInstance;
import com.manticore.tools.xmldoclet.xjc.Class;
import com.manticore.tools.xmldoclet.xjc.Constructor;
import com.manticore.tools.xmldoclet.xjc.Enum;
import com.manticore.tools.xmldoclet.xjc.EnumConstant;
import com.manticore.tools.xmldoclet.xjc.Field;
import com.manticore.tools.xmldoclet.xjc.Interface;
import com.manticore.tools.xmldoclet.xjc.Method;
import com.manticore.tools.xmldoclet.xjc.MethodParameter;
import com.manticore.tools.xmldoclet.xjc.ObjectFactory;
import com.manticore.tools.xmldoclet.xjc.Package;
import com.manticore.tools.xmldoclet.xjc.Root;
import com.manticore.tools.xmldoclet.xjc.TagInfo;
import com.manticore.tools.xmldoclet.xjc.TypeInfo;
import com.manticore.tools.xmldoclet.xjc.TypeParameter;
import com.manticore.tools.xmldoclet.xjc.Wildcard;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTrees;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import jdk.javadoc.doclet.DocletEnvironment;

public class Parser {
    protected final Map<String, Package> packages = new ConcurrentSkipListMap<String, Package>();
    protected final ObjectFactory objectFactory = new ObjectFactory();
    private final DocletEnvironment env;
    private final DocTrees docTrees;
    protected final TypeUtils typeUtils;

    public Parser(DocletEnvironment env) {
        this.env = env;
        this.docTrees = env.getDocTrees();
        this.typeUtils = new TypeUtils(env.getTypeUtils(), env.getElementUtils());
    }

    public Set<TypeElement> getClasses(DocletEnvironment env) {
        Set<? extends Element> elements = env.getIncludedElements();
        return ElementFilter.typesIn(elements);
    }

    String getJavaDoc(Element element) {
        DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(element);
        if (docCommentTree == null) {
            return "";
        }
        String commentText = docCommentTree.getFullBody().toString();
        commentText = commentText.replaceAll(",(<|&|>|;)", "$1");
        commentText = commentText.replaceAll("(<|&|>|;),", "$1");
        return commentText;
    }

    public List<? extends DocTree> getTags(Element element) {
        DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(element);
        return docCommentTree == null ? List.of() : docCommentTree.getBlockTags();
    }

    public Root parseRootDoc() {
        Root rootNode = this.objectFactory.createRoot();
        block5: for (TypeElement classDoc : this.getClasses(this.env)) {
            Package packageNode = this.getPackage(rootNode, classDoc);
            switch (classDoc.getKind()) {
                case ANNOTATION_TYPE: {
                    packageNode.getAnnotation().add(this.parseAnnotationTypeDoc(classDoc));
                    continue block5;
                }
                case ENUM: {
                    packageNode.getEnum().add(this.parseEnum(classDoc));
                    continue block5;
                }
                case INTERFACE: {
                    packageNode.getInterface().add(this.parseInterface(classDoc));
                    continue block5;
                }
            }
            packageNode.getClazz().add(this.parseClass(classDoc));
        }
        return rootNode;
    }

    Package getPackage(Root rootNode, TypeElement classElement) {
        try {
            PackageElement packageDoc = (PackageElement)Parser.getTopLevelClass(classElement).getEnclosingElement();
            return this.packages.computeIfAbsent(packageDoc.getQualifiedName().toString(), pkgName -> {
                Package packageNode = this.parsePackage(packageDoc);
                this.packages.put((String)pkgName, packageNode);
                rootNode.getPackage().add(packageNode);
                return packageNode;
            });
        }
        catch (Exception e) {
            String msg = "Error getting the package from element %s. kind %s: nesting kind: %s";
            throw new RuntimeException("Error getting the package from element %s. kind %s: nesting kind: %s".formatted(new Object[]{classElement.getQualifiedName(), classElement.getKind(), classElement.getNestingKind()}), e);
        }
    }

    static TypeElement getTopLevelClass(TypeElement classElement) {
        return TypeUtils.isInnerClass(classElement) ? Parser.getTopLevelClass((TypeElement)classElement.getEnclosingElement()) : classElement;
    }

    protected Package parsePackage(PackageElement packageDoc) {
        Package packageNode = this.objectFactory.createPackage();
        packageNode.setName(packageDoc.getQualifiedName().toString());
        String comment = this.getJavaDoc(packageDoc);
        if (!comment.isEmpty()) {
            packageNode.setComment(comment);
        }
        for (DocTree docTree : this.getTags(packageDoc)) {
            packageNode.getTag().add(this.parseTag(docTree));
        }
        return packageNode;
    }

    protected Annotation parseAnnotationTypeDoc(TypeElement annotationTypeDoc) {
        Annotation annotationNode = this.objectFactory.createAnnotation();
        annotationNode.setName(annotationTypeDoc.getSimpleName().toString());
        annotationNode.setQualified(TypeUtils.getQualifiedName(annotationTypeDoc));
        String comment = this.getJavaDoc(annotationTypeDoc);
        if (!comment.isEmpty()) {
            annotationNode.setComment(comment);
        }
        annotationNode.setScope(this.parseScope(annotationTypeDoc));
        for (ExecutableElement annotationTypeElementDoc : TypeUtils.getMethods(annotationTypeDoc)) {
            AnnotationElement annotationElement = this.parseAnnotationTypeElementDoc(annotationTypeElementDoc);
            annotationNode.getElement().add(annotationElement);
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : annotationTypeDoc.getAnnotationMirrors()) {
            AnnotationInstance annotationInstance = annotationParser.parse(annotationTypeDoc.getQualifiedName(), annotationMirror);
            annotationNode.getAnnotation().add(annotationInstance);
        }
        for (DocTree docTree : this.getTags(annotationTypeDoc)) {
            annotationNode.getTag().add(this.parseTag(docTree));
        }
        return annotationNode;
    }

    protected AnnotationElement parseAnnotationTypeElementDoc(ExecutableElement annotationTypeElementDoc) {
        AnnotationElement annotationElementNode = this.objectFactory.createAnnotationElement();
        annotationElementNode.setName(annotationTypeElementDoc.getSimpleName().toString());
        annotationElementNode.setQualified(TypeUtils.getQualifiedName(annotationTypeElementDoc));
        annotationElementNode.setType(this.parseTypeInfo(annotationTypeElementDoc.getReturnType()));
        AnnotationValue value = annotationTypeElementDoc.getDefaultValue();
        if (value != null) {
            annotationElementNode.setDefault(value.toString());
        }
        return annotationElementNode;
    }

    private static String getSimpleName(VariableElement element) {
        return element.getSimpleName().toString();
    }

    protected Enum parseEnum(TypeElement classDoc) {
        Enum enumNode = this.objectFactory.createEnum();
        enumNode.setName(classDoc.getSimpleName().toString());
        enumNode.setQualified(TypeUtils.getQualifiedName(classDoc));
        String comment = this.getJavaDoc(classDoc);
        if (!comment.isEmpty()) {
            enumNode.setComment(comment);
        }
        enumNode.setScope(this.parseScope(classDoc));
        TypeMirror superClassType = classDoc.getSuperclass();
        if (superClassType != null) {
            enumNode.setClazz(this.parseTypeInfo(superClassType));
        }
        for (TypeMirror typeMirror : classDoc.getInterfaces()) {
            enumNode.getInterface().add(this.parseTypeInfo(typeMirror));
        }
        for (VariableElement variableElement : TypeUtils.getEnumConstants(classDoc)) {
            enumNode.getConstant().add(this.parseEnumConstant(variableElement));
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : classDoc.getAnnotationMirrors()) {
            enumNode.getAnnotation().add(annotationParser.parse(classDoc.getQualifiedName(), annotationMirror));
        }
        for (DocTree docTree : this.getTags(classDoc)) {
            enumNode.getTag().add(this.parseTag(docTree));
        }
        return enumNode;
    }

    protected EnumConstant parseEnumConstant(VariableElement fieldDoc) {
        EnumConstant enumConstant = this.objectFactory.createEnumConstant();
        enumConstant.setName(Parser.getSimpleName(fieldDoc));
        String comment = this.getJavaDoc(fieldDoc);
        if (!comment.isEmpty()) {
            enumConstant.setComment(comment);
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : fieldDoc.getAnnotationMirrors()) {
            enumConstant.getAnnotation().add(annotationParser.parse(fieldDoc.getSimpleName(), annotationMirror));
        }
        for (DocTree docTree : this.getTags(fieldDoc)) {
            enumConstant.getTag().add(this.parseTag(docTree));
        }
        return enumConstant;
    }

    protected Interface parseInterface(TypeElement classDoc) {
        Interface interfaceNode = this.objectFactory.createInterface();
        interfaceNode.setName(classDoc.getSimpleName().toString());
        interfaceNode.setQualified(TypeUtils.getQualifiedName(classDoc));
        String comment = this.getJavaDoc(classDoc);
        if (!comment.isEmpty()) {
            interfaceNode.setComment(comment);
        }
        interfaceNode.setScope(this.parseScope(classDoc));
        for (TypeParameterElement typeParameterElement : classDoc.getTypeParameters()) {
            interfaceNode.getGeneric().add(this.parseTypeParameter(typeParameterElement));
        }
        for (TypeMirror typeMirror : classDoc.getInterfaces()) {
            interfaceNode.getInterface().add(this.parseTypeInfo(typeMirror));
        }
        for (ExecutableElement executableElement : TypeUtils.getMethods(classDoc)) {
            interfaceNode.getMethod().add(this.parseMethod(executableElement));
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : classDoc.getAnnotationMirrors()) {
            interfaceNode.getAnnotation().add(annotationParser.parse(classDoc.getQualifiedName(), annotationMirror));
        }
        for (DocTree docTree : this.getTags(classDoc)) {
            interfaceNode.getTag().add(this.parseTag(docTree));
        }
        for (VariableElement variableElement : TypeUtils.getFields(classDoc)) {
            interfaceNode.getField().add(this.parseField(variableElement));
        }
        return interfaceNode;
    }

    protected Class parseClass(TypeElement classDoc) {
        Class classNode = this.objectFactory.createClass();
        classNode.setName(classDoc.getSimpleName().toString());
        classNode.setQualified(TypeUtils.getQualifiedName(classDoc));
        String comment = this.getJavaDoc(classDoc);
        if (!comment.isEmpty()) {
            classNode.setComment(comment);
        }
        classNode.setAbstract(TypeUtils.hasModifier(classDoc, Modifier.ABSTRACT));
        classNode.setError(this.typeUtils.isError(classDoc));
        classNode.setException(this.typeUtils.isException(classDoc));
        classNode.setExternalizable(this.typeUtils.isExternalizable(classDoc));
        classNode.setSerializable(this.typeUtils.isSerializable(classDoc));
        classNode.setScope(this.parseScope(classDoc));
        for (TypeParameterElement typeParameterElement : classDoc.getTypeParameters()) {
            classNode.getGeneric().add(this.parseTypeParameter(typeParameterElement));
        }
        TypeMirror superClassType = classDoc.getSuperclass();
        if (superClassType != null) {
            classNode.setClazz(this.parseTypeInfo(superClassType));
        }
        for (TypeMirror typeMirror : classDoc.getInterfaces()) {
            classNode.getInterface().add(this.parseTypeInfo(typeMirror));
        }
        for (ExecutableElement executableElement : TypeUtils.getMethods(classDoc)) {
            classNode.getMethod().add(this.parseMethod(executableElement));
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : classDoc.getAnnotationMirrors()) {
            AnnotationInstance annotationInstance = annotationParser.parse(classDoc.getQualifiedName(), annotationMirror);
            classNode.getAnnotation().add(annotationInstance);
        }
        for (ExecutableElement executableElement : TypeUtils.getConstructors(classDoc)) {
            classNode.getConstructor().add(this.parseConstructor(executableElement));
        }
        for (VariableElement variableElement : TypeUtils.getFields(classDoc)) {
            classNode.getField().add(this.parseField(variableElement));
        }
        for (DocTree docTree : this.getTags(classDoc)) {
            classNode.getTag().add(this.parseTag(docTree));
        }
        return classNode;
    }

    protected Constructor parseConstructor(ExecutableElement constructorDoc) {
        Constructor constructorNode = this.objectFactory.createConstructor();
        constructorNode.setName(constructorDoc.getEnclosingElement().getSimpleName().toString());
        constructorNode.setQualified(constructorDoc.getSimpleName().toString());
        String comment = this.getJavaDoc(constructorDoc);
        if (!comment.isEmpty()) {
            constructorNode.setComment(comment);
        }
        constructorNode.setScope(this.parseScope(constructorDoc));
        constructorNode.setFinal(TypeUtils.hasModifier(constructorDoc, Modifier.FINAL));
        constructorNode.setNative(TypeUtils.hasModifier(constructorDoc, Modifier.NATIVE));
        constructorNode.setStatic(TypeUtils.hasModifier(constructorDoc, Modifier.STATIC));
        constructorNode.setSynchronized(TypeUtils.hasModifier(constructorDoc, Modifier.SYNCHRONIZED));
        constructorNode.setVarArgs(constructorDoc.isVarArgs());
        constructorNode.setSignature(TypeUtils.getMethodSignature(constructorDoc));
        for (VariableElement variableElement : constructorDoc.getParameters()) {
            constructorNode.getParameter().add(this.parseMethodParameter(variableElement));
        }
        for (TypeMirror typeMirror : constructorDoc.getThrownTypes()) {
            constructorNode.getException().add(this.parseTypeInfo(typeMirror));
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : constructorDoc.getAnnotationMirrors()) {
            AnnotationInstance annotationInstance = annotationParser.parse(constructorDoc.getSimpleName(), annotationMirror);
            constructorNode.getAnnotation().add(annotationInstance);
        }
        for (DocTree docTree : this.getTags(constructorDoc)) {
            constructorNode.getTag().add(this.parseTag(docTree));
        }
        return constructorNode;
    }

    protected Method parseMethod(ExecutableElement methodDoc) {
        Method methodNode = this.objectFactory.createMethod();
        methodNode.setName(methodDoc.getSimpleName().toString());
        methodNode.setQualified(methodDoc.getSimpleName().toString());
        String comment = this.getJavaDoc(methodDoc);
        if (!comment.isEmpty()) {
            methodNode.setComment(comment);
        }
        methodNode.setScope(this.parseScope(methodDoc));
        methodNode.setAbstract(TypeUtils.hasModifier(methodDoc, Modifier.ABSTRACT));
        methodNode.setFinal(TypeUtils.hasModifier(methodDoc, Modifier.FINAL));
        methodNode.setNative(TypeUtils.hasModifier(methodDoc, Modifier.NATIVE));
        methodNode.setStatic(TypeUtils.hasModifier(methodDoc, Modifier.STATIC));
        methodNode.setSynchronized(TypeUtils.hasModifier(methodDoc, Modifier.SYNCHRONIZED));
        methodNode.setVarArgs(methodDoc.isVarArgs());
        methodNode.setSignature(TypeUtils.getMethodSignature(methodDoc));
        methodNode.setReturn(this.parseTypeInfo(methodDoc.getReturnType()));
        for (VariableElement variableElement : methodDoc.getParameters()) {
            methodNode.getParameter().add(this.parseMethodParameter(variableElement));
        }
        for (TypeMirror typeMirror : methodDoc.getThrownTypes()) {
            methodNode.getException().add(this.parseTypeInfo(typeMirror));
        }
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : methodDoc.getAnnotationMirrors()) {
            AnnotationInstance annotationInstance = annotationParser.parse(methodDoc.getSimpleName(), annotationMirror);
            methodNode.getAnnotation().add(annotationInstance);
        }
        for (DocTree docTree : this.getTags(methodDoc)) {
            methodNode.getTag().add(this.parseTag(docTree));
        }
        return methodNode;
    }

    protected MethodParameter parseMethodParameter(VariableElement parameter) {
        MethodParameter parameterMethodNode = this.objectFactory.createMethodParameter();
        parameterMethodNode.setName(Parser.getSimpleName(parameter));
        parameterMethodNode.setType(this.parseTypeInfo(parameter.asType()));
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
            AnnotationInstance annotationInstance = annotationParser.parse(parameter.getSimpleName(), annotationMirror);
            parameterMethodNode.getAnnotation().add(annotationInstance);
        }
        return parameterMethodNode;
    }

    protected Field parseField(VariableElement fieldDoc) {
        Field fieldNode = this.objectFactory.createField();
        fieldNode.setType(this.parseTypeInfo(fieldDoc.asType()));
        fieldNode.setName(Parser.getSimpleName(fieldDoc));
        fieldNode.setQualified(Parser.getSimpleName(fieldDoc));
        String comment = this.getJavaDoc(fieldDoc);
        if (!comment.isEmpty()) {
            fieldNode.setComment(comment);
        }
        fieldNode.setScope(this.parseScope(fieldDoc));
        fieldNode.setFinal(TypeUtils.hasModifier(fieldDoc, Modifier.FINAL));
        fieldNode.setStatic(TypeUtils.hasModifier(fieldDoc, Modifier.STATIC));
        fieldNode.setVolatile(TypeUtils.hasModifier(fieldDoc, Modifier.VOLATILE));
        fieldNode.setTransient(TypeUtils.hasModifier(fieldDoc, Modifier.TRANSIENT));
        fieldNode.setConstant(Objects.requireNonNullElse(fieldDoc.getConstantValue(), "").toString());
        AnnotationParser annotationParser = new AnnotationParser(this);
        for (AnnotationMirror annotationMirror : fieldDoc.getAnnotationMirrors()) {
            fieldNode.getAnnotation().add(annotationParser.parse(fieldDoc.getSimpleName(), annotationMirror));
        }
        for (DocTree docTree : this.getTags(fieldDoc)) {
            fieldNode.getTag().add(this.parseTag(docTree));
        }
        return fieldNode;
    }

    protected Wildcard parseWildcard(WildcardType wildcard) {
        Wildcard wildcardNode = this.objectFactory.createWildcard();
        this.addIfNotNull(wildcardNode.getExtendsBound(), wildcard.getExtendsBound());
        this.addIfNotNull(wildcardNode.getSuperBound(), wildcard.getSuperBound());
        return wildcardNode;
    }

    private void addIfNotNull(List<TypeInfo> wildcardNode, TypeMirror extendType) {
        if (extendType != null) {
            wildcardNode.add(this.parseTypeInfo(extendType));
        }
    }

    protected TypeParameter parseTypeParameter(TypeParameterElement typeParameter) {
        return this.parseTypeParameter((TypeVariable)typeParameter.asType());
    }

    protected TypeParameter parseTypeParameter(TypeVariable typeVariable) {
        TypeMirror upperBound;
        TypeParameter typeParameter = this.objectFactory.createTypeParameter();
        typeParameter.setName(typeVariable.toString());
        List<String> bounds = typeParameter.getBound();
        TypeMirror lowerBound = typeVariable.getLowerBound();
        if (!"<nulltype>".equals(lowerBound.toString())) {
            bounds.addAll(this.parseTypeParameterBound(lowerBound));
        }
        if (!"java.lang.Object".equals((upperBound = typeVariable.getUpperBound()).toString())) {
            bounds.addAll(this.parseTypeParameterBound(upperBound));
        }
        return typeParameter;
    }

    private List<String> parseTypeParameterBound(TypeMirror bound) {
        String typesSeparator = "&";
        String boundName = bound.toString();
        return boundName.contains("&") ? List.of(boundName.split("&")) : List.of(boundName);
    }

    protected TagInfo parseTag(DocTree tagDoc) {
        TagInfo tagNode = this.objectFactory.createTagInfo();
        tagNode.setName(tagDoc.getKind().tagName);
        tagNode.setText(tagDoc.toString());
        return tagNode;
    }

    protected String parseScope(Element doc) {
        if (TypeUtils.hasModifier(doc, Modifier.PRIVATE)) {
            return "private";
        }
        if (TypeUtils.hasModifier(doc, Modifier.PROTECTED)) {
            return "protected";
        }
        if (TypeUtils.hasModifier(doc, Modifier.PUBLIC)) {
            return "public";
        }
        return "";
    }

    protected TypeInfo parseTypeInfo(TypeMirror type) {
        DeclaredType parameterized;
        WildcardType wildcard;
        TypeInfo typeInfoNode = this.objectFactory.createTypeInfo();
        typeInfoNode.setQualified(TypeUtils.getQualifiedName(type));
        String dimension = TypeUtils.getArrayDimension(type);
        if (!dimension.isEmpty()) {
            typeInfoNode.setDimension(dimension);
        }
        if ((wildcard = TypeUtils.getWildcardType(type)) != null) {
            typeInfoNode.setWildcard(this.parseWildcard(wildcard));
        }
        if ((parameterized = TypeUtils.getParameterizedType(type)) != null) {
            for (TypeMirror typeMirror : parameterized.getTypeArguments()) {
                typeInfoNode.getGeneric().add(this.parseTypeInfo(typeMirror));
            }
        }
        return typeInfoNode;
    }
}

