/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import com.manticore.tools.xmldoclet.CustomOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SupportedOptions {
    private final Map<String, String> givenCliOptionsMap = new HashMap<String, String>();
    private final Set<CustomOption> supportedOptionsSet = Set.of(this.newArgOption("d", "directory", "Destination directory for output file.\nDefault: ."), this.newArgOption("docencoding", "encoding", "Encoding of the output file.\nDefault: UTF8"), this.newNoArgOption("dryrun", "Parse javadoc, but don't write output file.\nDefault: false"), this.newNoArgOption("rst", "Transform the XML into a Restructured Text file (*.rst).\nDefault: false"), this.newNoArgOption("md", "Transform the XML into a Markdown file (*.md).\nDefault: false"), this.newNoArgOption("docbook", "Transform the XML into a DocBook file (*.db.xml).\nDefault: false"), this.newNoArgOption("adoc", "Transform the XML into an Ascii Doctor file (*.adoc).\nDefault: false"), this.newOneArgOption("filename", "Name of the output file.\nDefault: javadoc.xml"), this.newOneArgOption("basePackage", "Name of the base package.\n"), this.newOneArgOption("doctitle", "Document Title\n"), this.newOneArgOption("windowtitle", "Window Title\n"), this.newNoArgOption("noTimestamp", "No Timestamp.\n"), this.newNoArgOption("withFloatingToc", "Renders a Floating TOC on the right side.\n"));

    public Set<CustomOption> get() {
        return this.supportedOptionsSet;
    }

    private CustomOption newOneArgOption(String optionName, String description) {
        return CustomOption.newOneArg(optionName, description, optionName, this::processFirstArgValue);
    }

    private CustomOption newArgOption(String optionName, String argName, String description) {
        return CustomOption.newOneArg(optionName, description, argName, this::processFirstArgValue);
    }

    private CustomOption newNoArgOption(String optionName, String description) {
        return CustomOption.newNoArgs(optionName, description, (option, __) -> this.processNoArgValue((String)option));
    }

    private boolean processNoArgValue(String optionName) {
        this.storeParsedOption(optionName, null);
        return true;
    }

    private boolean processFirstArgValue(String optionName, List<String> argValues) {
        if (argValues.isEmpty()) {
            return false;
        }
        this.storeParsedOption(optionName, argValues.get(0));
        return true;
    }

    private void storeParsedOption(String optionName, String argValue) {
        this.givenCliOptionsMap.put(CustomOption.addHyphenPrefix(optionName), argValue);
    }

    public boolean hasOption(String optionName) {
        return this.givenCliOptionsMap.containsKey(CustomOption.addHyphenPrefix(optionName));
    }

    public String getOptionValue(CustomOption option) {
        return this.getOptionValue(option.getName());
    }

    public String getOptionValue(String optionName) {
        return this.getOptionValue(optionName, "");
    }

    public String getOptionValue(CustomOption option, String defaultValue) {
        return this.getOptionValue(option.getName(), defaultValue);
    }

    public String getOptionValue(String optionName, String defaultValue) {
        return this.givenCliOptionsMap.getOrDefault(CustomOption.addHyphenPrefix(optionName), defaultValue);
    }
}

