/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeUtils {
    private final Types types;
    private final Elements elements;
    private static final Pattern METHOD_SIGNATURE_WITH_RETURN_TYPE_AT_RIGHT_SIDE = Pattern.compile("^(\\(.*\\))(.*)");

    public TypeUtils(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
    }

    public static String getMethodSignature(ExecutableElement methodDoc) {
        return TypeUtils.getQualifiedName(methodDoc);
    }

    public static boolean hasModifier(Element element, Modifier modifier) {
        return element.getModifiers().contains((Object)modifier);
    }

    public static List<VariableElement> getFields(TypeElement classElement) {
        return ElementFilter.fieldsIn(classElement.getEnclosedElements());
    }

    public static List<ExecutableElement> getConstructors(TypeElement classElement) {
        return ElementFilter.constructorsIn(classElement.getEnclosedElements());
    }

    public static List<ExecutableElement> getMethods(TypeElement classElement) {
        return ElementFilter.methodsIn(classElement.getEnclosedElements());
    }

    public static WildcardType getWildcardType(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.WILDCARD) {
            return (WildcardType)typeMirror;
        }
        return null;
    }

    public static DeclaredType getParameterizedType(TypeMirror typeMirror) {
        DeclaredType declaredType;
        if (typeMirror instanceof DeclaredType && !(declaredType = (DeclaredType)typeMirror).getTypeArguments().isEmpty()) {
            return declaredType;
        }
        return null;
    }

    public static boolean isArray(TypeMirror typeMirror) {
        return typeMirror.getKind() == TypeKind.ARRAY;
    }

    public static String getArrayDimension(TypeMirror typeMirror) {
        int dimension = -1;
        TypeMirror type = typeMirror;
        while (type.getKind() == TypeKind.ARRAY) {
            ++dimension;
            type = ((ArrayType)type).getComponentType();
        }
        return dimension == -1 ? "" : String.valueOf(dimension + 1);
    }

    static String getQualifiedName(Element element) {
        return TypeUtils.getQualifiedName(element.asType());
    }

    static String getQualifiedName(TypeMirror typeMirror) {
        String qualified = typeMirror.toString();
        Matcher matcher = METHOD_SIGNATURE_WITH_RETURN_TYPE_AT_RIGHT_SIDE.matcher(qualified);
        return matcher.matches() ? matcher.group(2) + " " + matcher.group(1) : qualified;
    }

    public static List<VariableElement> getEnumConstants(TypeElement enumTypeElement) {
        return ElementFilter.fieldsIn(enumTypeElement.getEnclosedElements()).stream().filter(field -> field.getKind() == ElementKind.ENUM_CONSTANT).collect(Collectors.toList());
    }

    public static boolean isInnerClass(TypeElement classElement) {
        return classElement.getNestingKind() == NestingKind.MEMBER;
    }

    public boolean isException(TypeElement typeElement) {
        TypeMirror exceptionType = this.elements.getTypeElement("java.lang.Exception").asType();
        return this.types.isSubtype(typeElement.asType(), exceptionType);
    }

    public boolean isError(TypeElement typeElement) {
        TypeMirror errorType = this.elements.getTypeElement("java.lang.Error").asType();
        return this.types.isSubtype(typeElement.asType(), errorType);
    }

    public boolean isSerializable(TypeElement typeElement) {
        TypeMirror serializableType = this.elements.getTypeElement("java.io.Serializable").asType();
        return this.types.isSubtype(typeElement.asType(), serializableType);
    }

    public boolean isExternalizable(TypeElement typeElement) {
        TypeMirror serializableType = this.elements.getTypeElement("java.io.Externalizable").asType();
        return this.types.isSubtype(typeElement.asType(), serializableType);
    }
}

