/*
 * Decompiled with CFR 0.152.
 */
package com.manticore.tools.xmldoclet;

import com.manticore.tools.xmldoclet.ClasspathResourceURIResolver;
import com.manticore.tools.xmldoclet.CustomOption;
import com.manticore.tools.xmldoclet.Parser;
import com.manticore.tools.xmldoclet.SupportedOptions;
import com.manticore.tools.xmldoclet.xjc.Root;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.xml.transform.stream.StreamSource;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;

public final class XmlDoclet
implements Doclet {
    private static final Logger LOGGER = Logger.getLogger(XmlDoclet.class.getName());
    public static final String RESTRUCTURED_XSL = "/com/manticore/xsl/restructured.xsl";
    public static final String MARKDOWN_XSL = "/com/manticore/xsl/markdown.xsl";
    private static Root root;
    private final SupportedOptions options;
    private Reporter reporter;

    public XmlDoclet() {
        try {
            this.options = new SupportedOptions();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize XmlDoclet", e);
            throw new RuntimeException("Failed to initialize XmlDoclet", e);
        }
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Set<? extends CustomOption> getSupportedOptions() {
        return this.options.get();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean run(DocletEnvironment env) {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        root = new Parser(env).parseRootDoc();
        this.save(root);
        return true;
    }

    public static void transform(InputStream xsltInputStream, File xmlFile, File outFile, Map<String, String> parameters) throws IOException, SaxonApiException {
        try (FileInputStream xmlInputStream = new FileInputStream(xmlFile);
             FileOutputStream output = new FileOutputStream(outFile);){
            Processor processor = new Processor(false);
            DocumentBuilder docBuilder = processor.newDocumentBuilder();
            XdmNode xmlDoc = docBuilder.build(new StreamSource(xmlInputStream));
            XsltCompiler compiler = processor.newXsltCompiler();
            compiler.setResourceResolver(new ClasspathResourceURIResolver());
            XsltExecutable xsltExecutable = compiler.compile(new StreamSource(xsltInputStream));
            XsltTransformer transformer = xsltExecutable.load();
            transformer.setInitialContextNode(xmlDoc);
            Serializer serializer = processor.newSerializer(output);
            transformer.setDestination(serializer);
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                QName name = new QName(parameter.getKey());
                XdmAtomicValue values = new XdmAtomicValue(parameter.getValue());
                transformer.setParameter(name, values);
            }
            transformer.transform();
        }
    }

    public void save(Root root) {
        if (this.options.hasOption("dryrun")) {
            return;
        }
        String filename = this.options.getOptionValue("filename", "javadoc.xml");
        String basename = filename.toLowerCase().endsWith(".xml") ? filename.substring(0, filename.length() - ".xml".length()) : filename;
        File xmlFile = this.options.hasOption("d") ? new File(this.options.getOptionValue("d"), filename) : new File(filename);
        try (FileOutputStream fileOutputStream = new FileOutputStream(xmlFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            InputStream inputStream;
            File outFile;
            JAXBContext contextObj = JAXBContext.newInstance(Root.class);
            Marshaller marshaller = contextObj.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", true);
            if (this.options.hasOption("docencoding")) {
                marshaller.setProperty("jaxb.encoding", this.options.getOptionValue("docencoding"));
            }
            marshaller.marshal((Object)root, bufferedOutputStream);
            bufferedOutputStream.flush();
            fileOutputStream.flush();
            this.reporter.print(Diagnostic.Kind.NOTE, "Wrote XML to: " + xmlFile.getAbsolutePath());
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (CustomOption option : this.options.get()) {
                String optionValue = this.options.getOptionValue(option, "true");
                parameters.put(option.getParameters(), optionValue);
            }
            if (this.options.hasOption("rst")) {
                outFile = new File(xmlFile.getParent(), basename + ".rst");
                try {
                    inputStream = XmlDoclet.class.getResourceAsStream(RESTRUCTURED_XSL);
                    try {
                        XmlDoclet.transform(inputStream, xmlFile, outFile, parameters);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Failed to write Restructured Text", ex);
                }
                this.reporter.print(Diagnostic.Kind.NOTE, "Wrote Restructured Text to: " + outFile.getAbsolutePath());
            }
            if (this.options.hasOption("md")) {
                outFile = new File(xmlFile.getParent(), basename + ".md");
                try {
                    inputStream = XmlDoclet.class.getResourceAsStream(MARKDOWN_XSL);
                    try {
                        XmlDoclet.transform(inputStream, xmlFile, outFile, parameters);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Failed to write Markdown", ex);
                }
                this.reporter.print(Diagnostic.Kind.NOTE, "Wrote Markdown to: " + outFile.getAbsolutePath());
            }
            if (this.options.hasOption("docbook")) {
                this.reporter.print(Diagnostic.Kind.WARNING, "Docbook transformation is not supported yet.");
            }
            if (this.options.hasOption("adoc")) {
                this.reporter.print(Diagnostic.Kind.WARNING, "ASCII transformation is not supported yet.");
            }
        }
        catch (JAXBException | IOException | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to write the XML File", e);
        }
    }

    public static Root getRoot() {
        return root;
    }
}

