/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.ContextAccessorFunction;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class CurrentGroup
extends ContextAccessorFunction {
    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        return new CurrentGroupCall();
    }

    @Override
    public FunctionItem bindContext(XPathContext context) throws XPathException {
        if (this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() < 40) {
            throw new XPathException("Dynamic call on current-group() fails (the current group is absent)", "XTDE1061");
        }
        GroupIterator gi = context.getCurrentGroupIterator();
        if (gi == null) {
            throw new XPathException("There is no current group", "XTDE1061");
        }
        GroundedValue group = gi.currentGroup();
        ConstantFunction fn = new ConstantFunction(group);
        fn.setDetails(this.getDetails());
        fn.setRetainedStaticContext(this.getRetainedStaticContext());
        return fn;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("Dynamic call on current-group() fails (the current group is absent)", "XTDE1061");
    }
}

