/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.domain;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.domain.Domain;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetDomainRequest
implements Request<Domain> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain_id}";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain_id}");
    @NonNull
    private final String domainId;

    @Override
    public Domain execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain_id", (Object)Utils.emptyIfNull(this.domainId));
        return (Domain)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Domain.class);
    }

    public GetDomainRequest(@NonNull String domainId) {
        if (domainId == null) {
            throw new NullPointerException("domainId is marked non-null but is null");
        }
        this.domainId = domainId;
    }
}

