/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.message.Inbox;
import com.manybrain.mailinator.client.message.Sort;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetInboxRequest
implements Request<Inbox> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}");
    @NonNull
    private final String domain;
    private String inbox;
    private Integer skip;
    private Integer limit;
    private Sort sort;
    private Boolean decodeSubject;

    @Override
    public Inbox execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain)).resolveTemplate("inbox", (Object)Utils.emptyIfNull(this.inbox));
        if (this.skip != null) {
            webTarget = webTarget.queryParam("skip", new Object[]{this.skip});
        }
        if (this.limit != null) {
            webTarget = webTarget.queryParam("limit", new Object[]{this.limit});
        }
        if (this.sort != null) {
            webTarget = webTarget.queryParam("sort", new Object[]{this.sort.getType()});
        }
        if (this.decodeSubject != null) {
            webTarget = webTarget.queryParam("decode_subject", new Object[]{this.decodeSubject});
        }
        return (Inbox)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Inbox.class);
    }

    public static GetInboxRequestBuilder builder() {
        return new GetInboxRequestBuilder();
    }

    public GetInboxRequest(@NonNull String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.domain = domain;
    }

    public GetInboxRequest(@NonNull String domain, String inbox, Integer skip, Integer limit, Sort sort, Boolean decodeSubject) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.domain = domain;
        this.inbox = inbox;
        this.skip = skip;
        this.limit = limit;
        this.sort = sort;
        this.decodeSubject = decodeSubject;
    }

    public static class GetInboxRequestBuilder {
        private String domain;
        private String inbox;
        private Integer skip;
        private Integer limit;
        private Sort sort;
        private Boolean decodeSubject;

        GetInboxRequestBuilder() {
        }

        public GetInboxRequestBuilder domain(@NonNull String domain) {
            if (domain == null) {
                throw new NullPointerException("domain is marked non-null but is null");
            }
            this.domain = domain;
            return this;
        }

        public GetInboxRequestBuilder inbox(String inbox) {
            this.inbox = inbox;
            return this;
        }

        public GetInboxRequestBuilder skip(Integer skip) {
            this.skip = skip;
            return this;
        }

        public GetInboxRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetInboxRequestBuilder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public GetInboxRequestBuilder decodeSubject(Boolean decodeSubject) {
            this.decodeSubject = decodeSubject;
            return this;
        }

        public GetInboxRequest build() {
            return new GetInboxRequest(this.domain, this.inbox, this.skip, this.limit, this.sort, this.decodeSubject);
        }

        public String toString() {
            return "GetInboxRequest.GetInboxRequestBuilder(domain=" + this.domain + ", inbox=" + this.inbox + ", skip=" + this.skip + ", limit=" + this.limit + ", sort=" + (Object)((Object)this.sort) + ", decodeSubject=" + this.decodeSubject + ")";
        }
    }
}

