/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.message.Inbox;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetSmsInboxRequest
implements Request<Inbox> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/{phoneNumber}";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/{phoneNumber}");
    @NonNull
    private final String domain;
    @NonNull
    private final String phoneNumber;

    @Override
    public Inbox execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain)).resolveTemplate("phoneNumber", (Object)Utils.emptyIfNull(this.phoneNumber));
        return (Inbox)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Inbox.class);
    }

    public GetSmsInboxRequest(@NonNull String domain, @NonNull String phoneNumber) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        this.domain = domain;
        this.phoneNumber = phoneNumber;
    }
}

