/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.rule;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.rule.Rule;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetRuleRequest
implements Request<Rule> {
    private static final String URL = "https://api.mailinator.com/streams/:stream_id/rules/:rule_id";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/streams/:stream_id/rules/:rule_id");
    @NonNull
    private final String streamId;
    @NonNull
    private final String ruleId;

    @Override
    public Rule execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("stream_id", (Object)Utils.emptyIfNull(this.streamId)).resolveTemplate("ruleId", (Object)Utils.emptyIfNull(this.ruleId));
        return (Rule)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Rule.class);
    }

    public GetRuleRequest(@NonNull String streamId, @NonNull String ruleId) {
        if (streamId == null) {
            throw new NullPointerException("streamId is marked non-null but is null");
        }
        if (ruleId == null) {
            throw new NullPointerException("ruleId is marked non-null but is null");
        }
        this.streamId = streamId;
        this.ruleId = ruleId;
    }
}

