/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.message.DeletedMessages;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class DeleteDomainMessagesRequest
implements Request<DeletedMessages> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/");
    @NonNull
    private final String domain;

    @Override
    public DeletedMessages execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain));
        return (DeletedMessages)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).delete(DeletedMessages.class);
    }

    public DeleteDomainMessagesRequest(@NonNull String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        this.domain = domain;
    }
}

