/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import java.io.File;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetAttachmentRequest
implements Request<File> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages/{message_id}/attachments/{attachment_id}";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages/{message_id}/attachments/{attachment_id}");
    @NonNull
    private final String domain;
    @NonNull
    private final String inbox;
    @NonNull
    private final String messageId;
    @NonNull
    private final Integer attachmentId;

    @Override
    public File execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain)).resolveTemplate("inbox", (Object)Utils.emptyIfNull(this.inbox)).resolveTemplate("message_id", (Object)Utils.emptyIfNull(this.messageId)).resolveTemplate("attachment_id", (Object)this.attachmentId);
        return (File)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(File.class);
    }

    public GetAttachmentRequest(@NonNull String domain, @NonNull String inbox, @NonNull String messageId, @NonNull Integer attachmentId) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (inbox == null) {
            throw new NullPointerException("inbox is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (attachmentId == null) {
            throw new NullPointerException("attachmentId is marked non-null but is null");
        }
        this.domain = domain;
        this.inbox = inbox;
        this.messageId = messageId;
        this.attachmentId = attachmentId;
    }
}

