/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.message.Links;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetLinksRequest
implements Request<Links> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages/{message_id}/links";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages/{message_id}/links");
    @NonNull
    private final String domain;
    @NonNull
    private final String inbox;
    @NonNull
    private final String messageId;

    @Override
    public Links execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain)).resolveTemplate("inbox", (Object)Utils.emptyIfNull(this.inbox)).resolveTemplate("message_id", (Object)Utils.emptyIfNull(this.messageId));
        return (Links)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Links.class);
    }

    public GetLinksRequest(@NonNull String domain, @NonNull String inbox, @NonNull String messageId) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (inbox == null) {
            throw new NullPointerException("inbox is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.domain = domain;
        this.inbox = inbox;
        this.messageId = messageId;
    }
}

