/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.message;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.message.MessageToPost;
import com.manybrain.mailinator.client.message.PostedMessage;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class PostMessageRequest
implements Request<PostedMessage> {
    private static final String URL = "https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/v2/domains/{domain}/inboxes/{inbox}/messages");
    @NonNull
    private final String domain;
    @NonNull
    private final String inbox;
    @NonNull
    private final MessageToPost message;

    @Override
    public PostedMessage execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain", (Object)Utils.emptyIfNull(this.domain)).resolveTemplate("inbox", (Object)Utils.emptyIfNull(this.inbox));
        return (PostedMessage)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).post(Entity.json((Object)this.message), PostedMessage.class);
    }

    public PostMessageRequest(@NonNull String domain, @NonNull String inbox, @NonNull MessageToPost message) {
        if (domain == null) {
            throw new NullPointerException("domain is marked non-null but is null");
        }
        if (inbox == null) {
            throw new NullPointerException("inbox is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.domain = domain;
        this.inbox = inbox;
        this.message = message;
    }
}

