/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.rule;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.rule.Rule;
import com.manybrain.mailinator.client.rule.RuleToCreate;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class CreateRuleRequest
implements Request<Rule> {
    private static final String URL = "https://api.mailinator.com/api/v2/domains/{domain_id}/rules/";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/api/v2/domains/{domain_id}/rules/");
    @NonNull
    private final String domainId;
    @NonNull
    private final RuleToCreate rule;

    @Override
    public Rule execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain_id", (Object)Utils.emptyIfNull(this.domainId));
        return (Rule)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).post(Entity.json((Object)this.rule), Rule.class);
    }

    public CreateRuleRequest(@NonNull String domainId, @NonNull RuleToCreate rule) {
        if (domainId == null) {
            throw new NullPointerException("domainId is marked non-null but is null");
        }
        if (rule == null) {
            throw new NullPointerException("rule is marked non-null but is null");
        }
        this.domainId = domainId;
        this.rule = rule;
    }
}

