/*
 * Decompiled with CFR 0.152.
 */
package com.manybrain.mailinator.client.rule;

import com.manybrain.mailinator.client.JerseyClient;
import com.manybrain.mailinator.client.Request;
import com.manybrain.mailinator.client.Utils;
import com.manybrain.mailinator.client.rule.Rules;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import lombok.NonNull;

public class GetRulesRequest
implements Request<Rules> {
    private static final String URL = "https://api.mailinator.com/api/v2/domains/{domain_id}/rules/";
    private static final WebTarget WEB_TARGET = JerseyClient.CLIENT.target("https://api.mailinator.com/api/v2/domains/{domain_id}/rules/");
    @NonNull
    private final String domainId;

    @Override
    public Rules execute(String apiToken) {
        WebTarget webTarget = WEB_TARGET.resolveTemplate("domain_id", (Object)Utils.emptyIfNull(this.domainId));
        return (Rules)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)apiToken).get(Rules.class);
    }

    public GetRulesRequest(@NonNull String domainId) {
        if (domainId == null) {
            throw new NullPointerException("domainId is marked non-null but is null");
        }
        this.domainId = domainId;
    }
}

