/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.FormElement;
import com.manydesigns.elements.KeyValueAccessor;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.composites.AbstractCompositeElement;
import com.manydesigns.elements.fields.MultipartRequestField;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FieldSet
extends AbstractCompositeElement<FormElement> {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final int nColumns;
    protected final Mode mode;
    protected String name;

    public FieldSet(String name, int nColumns, Mode mode) {
        this.name = name;
        this.nColumns = nColumns;
        this.mode = mode;
        if (nColumns > 4 && nColumns != 6) {
            throw new IllegalArgumentException("nColumns = " + nColumns + " but only 1, 2, 3, 4, 6 columns are supported");
        }
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        if (this.mode.isHidden()) {
            for (FormElement current : this) {
                current.toXhtml(xb);
            }
        } else {
            xb.openElement("fieldset");
            xb.addAttribute("class", "mde-columns-" + this.nColumns);
            if (this.name != null) {
                xb.writeLegend(this.name, null);
            }
            int currentColumn = 0;
            for (FormElement current : this) {
                int colSpan = Math.min(current.getColSpan(), this.nColumns);
                if ((current.isForceNewRow() || currentColumn + colSpan > this.nColumns) && currentColumn > 0) {
                    this.closeCurrentRow(xb, currentColumn);
                    currentColumn = 0;
                }
                if (currentColumn == 0) {
                    xb.openElement("div");
                    xb.addAttribute("class", "row");
                }
                xb.openElement("div");
                xb.addAttribute("class", "col-md-" + colSpan * (12 / this.nColumns) + " mde-colspan-" + colSpan);
                current.toXhtml(xb);
                xb.closeElement("div");
                if ((currentColumn += colSpan) < this.nColumns) continue;
                this.closeCurrentRow(xb, currentColumn);
                currentColumn = 0;
            }
            if (currentColumn > 0) {
                this.closeCurrentRow(xb, currentColumn);
            }
            xb.closeElement("fieldset");
        }
    }

    protected void closeCurrentRow(XhtmlBuffer xb, int currentColumn) {
        if (currentColumn < this.nColumns) {
            xb.openElement("div");
            xb.addAttribute("class", "col-md-" + (this.nColumns - currentColumn) * (12 / this.nColumns));
            xb.closeElement("div");
        }
        xb.closeElement("div");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isRequiredFieldsPresent() {
        for (FormElement current : this) {
            if (!current.hasRequiredFields()) continue;
            return true;
        }
        return false;
    }

    public boolean isMultipartRequest() {
        for (FormElement current : this) {
            MultipartRequestField field;
            if (!(current instanceof MultipartRequestField) || (field = (MultipartRequestField)current).getMode().isView(field.isInsertable(), field.isUpdatable())) continue;
            return true;
        }
        return false;
    }

    public void readFrom(KeyValueAccessor accessor) {
        for (FormElement current : this) {
            current.readFrom(accessor);
        }
    }

    public void writeTo(KeyValueAccessor accessor) {
        for (FormElement current : this) {
            current.writeTo(accessor);
        }
    }

    public Map<String, Object> getValue() {
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (FormElement current : this) {
            value.put(current.getName(), current.getValue());
        }
        return value;
    }

    public int getNColumns() {
        return this.nColumns;
    }
}

