/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.GroovyCodeBase;
import com.manydesigns.portofino.dispatcher.resolvers.AbstractResourceResolver;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyResourceResolver
extends AbstractResourceResolver {
    protected final GroovyCodeBase groovyCodeBase;
    protected static final Logger logger = LoggerFactory.getLogger(GroovyResourceResolver.class);

    public GroovyResourceResolver() {
        this(GroovyResourceResolver.getGroovyCodeBase(null));
    }

    public GroovyResourceResolver(GroovyCodeBase groovyCodeBase) {
        this.groovyCodeBase = groovyCodeBase;
    }

    public GroovyResourceResolver(CodeBase codeBase) {
        this(GroovyResourceResolver.getGroovyCodeBase(codeBase));
    }

    protected static GroovyCodeBase getGroovyCodeBase(CodeBase codeBase) {
        if (codeBase instanceof GroovyCodeBase) {
            return (GroovyCodeBase)codeBase;
        }
        try {
            return new GroovyCodeBase(VFS.getManager().resolveFile("ram:///" + GroovyResourceResolver.class.getName()), codeBase);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> T resolve(FileObject location, Class<T> type) throws Exception {
        FileObject actualLocation = this.resolve(location);
        if (actualLocation == null) {
            return null;
        }
        return type.cast(this.groovyCodeBase.loadGroovyFile(actualLocation));
    }

    @Override
    public boolean supports(Class<?> type) {
        return type == Class.class;
    }

    @Override
    public boolean supports(String extension) {
        return "groovy".equals(extension);
    }
}

