/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.manydesigns.portofino.code.CodeBase;
import com.manydesigns.portofino.code.JavaCodeBase;
import com.manydesigns.portofino.dispatcher.resolvers.AbstractResourceResolver;
import com.manydesigns.portofino.dispatcher.resolvers.CachingResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;

public class JavaResourceResolver
extends CachingResourceResolver {
    protected CodeBase codeBase;

    public JavaResourceResolver() {
    }

    public JavaResourceResolver(CodeBase codeBase) {
        this.codeBase = codeBase;
    }

    @Override
    protected <T> T doResolve(FileObject location, Class<T> type) throws Exception {
        FileObject actualLocation = this.resolve(location);
        if (actualLocation != null) {
            if ("class".equals(actualLocation.getName().getExtension())) {
                return type.cast(this.resolveClassFile(actualLocation));
            }
            if ("java".equals(actualLocation.getName().getExtension())) {
                return type.cast(this.resolveJavaFile(actualLocation));
            }
        }
        return null;
    }

    @Override
    public FileObject resolve(FileObject location) throws FileSystemException {
        return AbstractResourceResolver.resolve(this, location);
    }

    @Override
    public FileObject resolve(FileObject location, String name) throws FileSystemException {
        return AbstractResourceResolver.resolve(this, location, name);
    }

    @Override
    public boolean supports(Class<?> type) {
        return type == Class.class;
    }

    @Override
    public boolean supports(String extension) {
        return "java".equals(extension) || "class".equals(extension);
    }

    protected Class resolveClassFile(FileObject location) throws Exception {
        return new JavaCodeBase(location.getParent(), this.codeBase).loadClassFile(location, JavaResourceResolver.getBaseName(location));
    }

    public CodeBase getCodeBase() {
        return this.codeBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveJavaFile(FileObject fileObject) throws ClassNotFoundException, IOException {
        try {
            JavaType result = Roaster.parse((InputStream)fileObject.getContent().getInputStream());
            String className = result.getQualifiedName();
            Class clazz = new JavaCodeBase(fileObject.getParent(), this.codeBase).loadJavaFile(fileObject, className);
            return clazz;
        }
        finally {
            fileObject.close();
        }
    }

    protected static String getBaseName(FileObject fileObject) {
        return FilenameUtils.getBaseName((String)fileObject.getName().getBaseName());
    }
}

