/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher;

import com.manydesigns.portofino.dispatcher.AbstractResource;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.ResourceResolver;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;

public class Root
extends AbstractResource {
    protected ResourceResolver resourceResolver;

    public static Resource get(FileObject location, ResourceResolver resourceResolver) throws Exception {
        Resource root;
        if (!location.exists() || location.getType() != FileType.FOLDER) {
            throw new FileNotFolderException((Object)location);
        }
        Class rootClass = resourceResolver.resolve(location, Class.class);
        if (rootClass != null) {
            if (Resource.class.isAssignableFrom(rootClass)) {
                Constructor constructor = rootClass.getConstructor(FileObject.class, ResourceResolver.class);
                root = (Resource)constructor.newInstance(location, resourceResolver);
            } else {
                logger.warn(rootClass + " defined in " + location + " does not extend Root, ignoring");
                root = new Root(location, resourceResolver);
            }
        } else {
            root = new Root(location, resourceResolver);
        }
        return root;
    }

    protected Root(FileObject location, ResourceResolver resourceResolver) {
        this.setLocation(location);
        this.resourceResolver = resourceResolver;
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public void setParent(Resource parent) {
        throw new UnsupportedOperationException("Cannot set the parent of the root");
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @GET
    @Produces(value={"application/json"})
    public Response homeJSON() throws URISyntaxException {
        return Response.temporaryRedirect((URI)new URI("swagger.json")).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    public Response homeYAML() throws URISyntaxException {
        return Response.temporaryRedirect((URI)new URI("swagger.yaml")).build();
    }

    @Override
    public Root init() {
        return this;
    }
}

