/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.resolvers;

import com.manydesigns.portofino.dispatcher.ResourceResolver;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public abstract class AbstractResourceResolver
implements ResourceResolver {
    @Override
    public FileObject resolve(FileObject location) throws FileSystemException {
        return AbstractResourceResolver.resolve(this, location);
    }

    @Override
    public FileObject resolve(FileObject location, String name) throws FileSystemException {
        return AbstractResourceResolver.resolve(this, location, name);
    }

    @Override
    public <T> T resolve(FileObject location, String name, Class<T> type) throws Exception {
        return this.resolve(this.resolve(location, name), type);
    }

    public static FileObject resolve(ResourceResolver resolver, FileObject location) throws FileSystemException {
        return AbstractResourceResolver.resolve(resolver, location, null);
    }

    public static FileObject resolve(ResourceResolver resolver, FileObject location, String name) throws FileSystemException {
        if (location == null) {
            return null;
        }
        if (location.getType() == FileType.FILE || location.getType() == FileType.IMAGINARY) {
            if (AbstractResourceResolver.isSupportedResource(resolver, location, name)) {
                return location;
            }
            return null;
        }
        FileObject resource = null;
        for (FileObject candidate : location.getChildren()) {
            if (!AbstractResourceResolver.isSupportedResource(resolver, candidate, name)) continue;
            if (resource == null) {
                resource = candidate;
                continue;
            }
            throw new RuntimeException("Multiple candidate resources: " + resource + ", " + candidate);
        }
        return resource;
    }

    public static boolean isSupportedResource(ResourceResolver resolver, FileObject location, String name) {
        String nameWithoutExtension = FilenameUtils.getBaseName((String)location.getName().getBaseName());
        return (name == null || nameWithoutExtension.equals(name)) && resolver.supports(location.getName().getExtension());
    }
}

