/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security;

import com.manydesigns.portofino.dispatcher.security.RolesPermission;
import java.lang.reflect.Method;
import java.util.Collections;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmWrapper
extends AuthorizingRealm {
    protected static final Logger logger = LoggerFactory.getLogger(RealmWrapper.class);
    protected AuthorizingRealm realm;
    protected Method getAuthorizationInfoMethod;

    public RealmWrapper() {
    }

    public RealmWrapper(AuthorizingRealm realm) {
        this.setRealm(realm);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            AuthorizationInfo info = (AuthorizationInfo)this.getAuthorizationInfoMethod.invoke((Object)this.realm, principals);
            if (info.getObjectPermissions() != null) {
                for (Permission p : info.getObjectPermissions()) {
                    if (!(p instanceof RolesPermission)) continue;
                    return info;
                }
                info.getObjectPermissions().add(new RolesPermission(info.getRoles()));
            } else if (info instanceof SimpleAuthorizationInfo) {
                ((SimpleAuthorizationInfo)info).setObjectPermissions(Collections.singleton(new RolesPermission(info.getRoles())));
            } else if (info instanceof SimpleAccount) {
                ((SimpleAccount)info).setObjectPermissions(Collections.singleton(new RolesPermission(info.getRoles())));
            } else {
                logger.warn("Cannot add RolesPermission to the AuthorizationInfo {}", (Object)info);
            }
            return info;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return this.realm.getAuthenticationInfo(token);
    }

    public AuthorizingRealm getRealm() {
        return this.realm;
    }

    public void setRealm(AuthorizingRealm realm) {
        Class<?> realmClass = realm.getClass();
        this.getAuthorizationInfoMethod = this.lookupGetAuthorizationInfoMethod(realmClass);
        this.realm = realm;
    }

    protected Method lookupGetAuthorizationInfoMethod(Class<?> realmClass) {
        if (!AuthorizingRealm.class.isAssignableFrom(realmClass)) {
            throw new RuntimeException("Not an AuthorizingRealm!");
        }
        try {
            Method getAuthorizationInfo = realmClass.getDeclaredMethod("getAuthorizationInfo", PrincipalCollection.class);
            getAuthorizationInfo.setAccessible(true);
            return getAuthorizationInfo;
        }
        catch (NoSuchMethodException e) {
            return this.lookupGetAuthorizationInfoMethod(realmClass.getSuperclass());
        }
    }
}

