/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security;

import com.manydesigns.portofino.dispatcher.security.OperationPermission;
import com.manydesigns.portofino.dispatcher.security.ResourcePermissions;
import com.manydesigns.portofino.dispatcher.security.RolesPermission;
import com.manydesigns.portofino.dispatcher.security.SecureResource;
import java.util.Collections;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.aop.PermissionAnnotationMethodInterceptor;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMethodInterceptor
extends PermissionAnnotationMethodInterceptor {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceMethodInterceptor.class);

    public void assertAuthorized(MethodInvocation mi) throws AuthorizationException {
        if (mi.getThis() instanceof SecureResource) {
            RequiresPermissions annotation = (RequiresPermissions)this.getAnnotation(mi);
            String[] value = annotation.value();
            boolean allowed = annotation.logical() == Logical.AND || value.length == 0;
            ResourcePermissions resourcePermissions = ((SecureResource)mi.getThis()).getPermissions();
            for (String permission : value) {
                OperationPermission op = resourcePermissions.getPermission((Permission)new WildcardPermission(permission));
                if (annotation.logical() == Logical.AND) {
                    if (this.isPermitted(op)) continue;
                    this.notPermitted(mi);
                    continue;
                }
                allowed |= this.isPermitted(op);
            }
            if (!allowed) {
                this.notPermitted(mi);
            }
        } else {
            super.assertAuthorized(mi);
        }
    }

    protected void notPermitted(MethodInvocation mi) {
        logger.debug("Subject not authorized according to resource and role permissions. Checking default permissions.");
        super.assertAuthorized(mi);
    }

    protected boolean isPermitted(OperationPermission op) {
        if (this.getSubject().isAuthenticated()) {
            return this.getSubject().isPermitted((Permission)op);
        }
        return new RolesPermission(Collections.singleton("")).implies(op);
    }
}

