/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.security;

import com.manydesigns.portofino.dispatcher.security.ResourceMethodInterceptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.aop.AnnotationsAuthorizingMethodInterceptor;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.GuestAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.RoleAnnotationMethodInterceptor;
import org.apache.shiro.authz.aop.UserAnnotationMethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class ShiroResourceFilter
implements ContainerRequestFilter {
    protected static final Logger logger = LoggerFactory.getLogger(ShiroResourceFilter.class);
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    protected HttpServletResponse response;
    protected static final AuthChecker AUTH_CHECKER = new AuthChecker();

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo uriInfo = requestContext.getUriInfo();
        if (uriInfo.getMatchedResources().isEmpty()) {
            logger.debug("No resources matched {}", (Object)uriInfo.getPath());
            return;
        }
        if (this.resourceInfo == null || this.resourceInfo.getResourceClass() == null) {
            logger.debug("No resource info: {}", (Object)this.resourceInfo);
            return;
        }
        Object resource = uriInfo.getMatchedResources().get(0);
        this.checkAuthorizations(requestContext, resource);
    }

    protected void checkAuthorizations(ContainerRequestContext requestContext, Object resource) {
        try {
            Method handler = this.resourceInfo.getResourceMethod();
            AUTH_CHECKER.assertAuthorized(resource, handler);
            logger.debug("Security check passed.");
        }
        catch (AuthorizationException e) {
            logger.warn("Method invocation not authorized", (Throwable)e);
            if (SecurityUtils.getSubject().isAuthenticated()) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
            }
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    public static final class AuthChecker
    extends AnnotationsAuthorizingMethodInterceptor {
        public AuthChecker() {
            this.methodInterceptors = new ArrayList(5);
            this.methodInterceptors.add(new RoleAnnotationMethodInterceptor());
            this.methodInterceptors.add(new ResourceMethodInterceptor());
            this.methodInterceptors.add(new AuthenticatedAnnotationMethodInterceptor());
            this.methodInterceptors.add(new UserAnnotationMethodInterceptor());
            this.methodInterceptors.add(new GuestAnnotationMethodInterceptor());
        }

        public void assertAuthorized(final Object resource, final Method handler) throws AuthorizationException {
            super.assertAuthorized(new MethodInvocation(){

                public Object proceed() throws Throwable {
                    return null;
                }

                public Method getMethod() {
                    return handler;
                }

                public Object[] getArguments() {
                    return new Object[handler.getParameterTypes().length];
                }

                public Object getThis() {
                    return resource;
                }
            });
        }
    }
}

