/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.visitor;

import com.manydesigns.portofino.dispatcher.AbstractResource;
import com.manydesigns.portofino.dispatcher.Resource;
import com.manydesigns.portofino.dispatcher.WithParameters;
import com.manydesigns.portofino.dispatcher.visitor.ResourceVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepthFirstVisitor {
    protected final List<ResourceVisitor> visitors = new ArrayList<ResourceVisitor>();
    protected static final Logger logger = LoggerFactory.getLogger(DepthFirstVisitor.class);
    public int maxParameters = 10;

    public DepthFirstVisitor(ResourceVisitor ... visitors) {
        this.visitors.addAll(Arrays.asList(visitors));
    }

    public List<ResourceVisitor> getVisitors() {
        return this.visitors;
    }

    public void visit(Resource resource) throws Exception {
        int i;
        WithParameters withParameters;
        if (resource instanceof WithParameters) {
            withParameters = (WithParameters)((Object)resource);
            for (i = 0; i < withParameters.getMinParameters(); ++i) {
                withParameters.consumeParameter("{" + withParameters.getParameterName(i) + "}");
            }
        }
        this.visitResource(resource);
        if (resource instanceof WithParameters && ((WithParameters)((Object)resource)).getMinParameters() == 0) {
            withParameters = (WithParameters)((Object)resource);
            for (i = 0; i < Math.min(this.maxParameters, withParameters.getMaxParameters()); ++i) {
                withParameters.consumeParameter("{" + withParameters.getParameterName(i) + "}");
            }
            this.visitResource(resource);
        }
    }

    protected void visitResource(Resource resource) throws Exception {
        for (ResourceVisitor visitor : this.visitors) {
            visitor.visit(resource);
        }
        this.visitSubResources(resource);
    }

    protected void visitSubResources(Resource resource) throws FileSystemException {
        for (String subResourceName : resource.getSubResources()) {
            try {
                Object element = resource.getSubResource(subResourceName);
                if (!(element instanceof AbstractResource)) continue;
                this.visit((AbstractResource)element);
            }
            catch (Throwable e) {
                this.handleError(resource, e);
            }
        }
    }

    public void handleError(Resource resource, Throwable e) throws FileSystemException {
        logger.error("Could not visit resource " + resource.getLocation().getURL(), e);
    }
}

