/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.dispatcher.web;

import com.manydesigns.portofino.dispatcher.DispatcherInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDispatcherInitializer
extends DispatcherInitializer
implements ServletContextListener {
    public static final String PORTOFINO_APPLICATION_DIRECTORY_PARAMETER = "portofino.application.directory";
    public static final String CODE_BASE_ATTRIBUTE = "portofino.codebase";
    private static final Logger logger = LoggerFactory.getLogger(WebDispatcherInitializer.class);
    protected ServletContext servletContext;

    public void contextInitialized(ServletContextEvent sce) {
        this.initWithServletContext(sce.getServletContext());
    }

    public void initWithServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.initialize();
        servletContext.setAttribute(CODE_BASE_ATTRIBUTE, (Object)this.codeBase);
        servletContext.setAttribute("portofino.configuration", (Object)this.configuration);
    }

    @Override
    protected FileObject getDefaultApplicationRoot() throws FileSystemException {
        return VFS.getManager().resolveFile(this.servletContext.getRealPath("")).resolveFile("WEB-INF");
    }

    @Override
    protected String getApplicationDirectoryPath() {
        return this.servletContext.getInitParameter(PORTOFINO_APPLICATION_DIRECTORY_PARAMETER);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        logger.info("Application destroyed.");
    }
}

