/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model;

import com.manydesigns.portofino.model.Annotation;
import java.util.List;
import java.util.Optional;

public interface Annotated {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";

    public List<Annotation> getAnnotations();

    default public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
        annotation.setParent(this);
    }

    default public <T extends java.lang.annotation.Annotation> Optional<T> getJavaAnnotation(Class<T> annotationClass) {
        return this.getAnnotations().stream().filter(a -> annotationClass.isAssignableFrom(a.getJavaAnnotationClass())).map(Annotation::getJavaAnnotation).findFirst();
    }

    default public Optional<Annotation> getAnnotation(String type) {
        return this.getAnnotations().stream().filter(a -> a.getType().equals(type)).findFirst();
    }

    default public Annotation ensureAnnotation(String type) {
        return this.getAnnotation(type).orElseGet(() -> {
            Annotation annotation = new Annotation((Object)this, type);
            this.getAnnotations().add(annotation);
            return annotation;
        });
    }

    default public Optional<Annotation> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotations().stream().filter(a -> a.getJavaAnnotationClass() != null && type.isAssignableFrom(a.getJavaAnnotationClass()) || a.getType().equals(type.getName())).findFirst();
    }

    default public Annotation ensureAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotation(type).orElseGet(() -> {
            Annotation annotation = new Annotation((Object)this, type);
            this.getAnnotations().add(annotation);
            return annotation;
        });
    }

    default public <T extends java.lang.annotation.Annotation> boolean removeAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass).map(a -> this.getAnnotations().remove(a)).orElse(false);
    }
}

