/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.manydesigns.elements.annotations.AnnotationFactory;
import com.manydesigns.elements.annotations.AnnotationsManager;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.util.ReflectionUtil;
import com.manydesigns.elements.util.Util;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Annotation
implements ModelObject {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected Object parent;
    protected String type;
    @Deprecated
    protected List<String> values = new ArrayList<String>();
    protected List<Property> properties = new ArrayList<Property>();
    protected Class<? extends java.lang.annotation.Annotation> javaAnnotationClass;
    protected java.lang.annotation.Annotation javaAnnotation;
    public static final Logger logger = LoggerFactory.getLogger(Annotation.class);

    public Annotation() {
    }

    public Annotation(String type) {
        this(null, type);
    }

    public Annotation(Object parent, String type) {
        this.parent = parent;
        this.type = type;
    }

    public Annotation(Class<? extends java.lang.annotation.Annotation> type) {
        this(null, type);
    }

    public Annotation(Object parent, Class<? extends java.lang.annotation.Annotation> type) {
        this.parent = parent;
        this.type = type.getName();
        this.javaAnnotationClass = type;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.parent = parent;
    }

    @Override
    public void reset() {
        this.javaAnnotation = null;
        this.javaAnnotationClass = null;
    }

    @Override
    public void init(Model model, Configuration configuration) {
        java.lang.annotation.Annotation legacyAnnotation;
        this.javaAnnotationClass = ReflectionUtil.loadClass((String)this.type);
        if (this.javaAnnotationClass == null) {
            logger.error("Cannot load annotation class: {}", (Object)this.type);
            return;
        }
        if (!java.lang.annotation.Annotation.class.isAssignableFrom(this.javaAnnotationClass)) {
            logger.error("Not an annotation: " + this.javaAnnotationClass);
            this.javaAnnotationClass = null;
            return;
        }
        if (this.properties.isEmpty() && (legacyAnnotation = this.createLegacyAnnotation()) != null) {
            this.javaAnnotation = legacyAnnotation;
            try {
                logger.info("Migrating annotation " + this.javaAnnotation + " to new format");
                ArrayList<Property> properties = new ArrayList<Property>();
                for (Method method : AnnotationFactory.getAnnotationMethods(this.javaAnnotationClass)) {
                    Property property = new Property();
                    property.setName(method.getName());
                    Object value = method.invoke((Object)this.javaAnnotation, new Object[0]);
                    property.setValue(OgnlUtils.convertValueToString((Object)value));
                    properties.add(property);
                }
                this.properties.addAll(properties);
                this.values.clear();
            }
            catch (Exception e) {
                logger.error("Migration failed", (Throwable)e);
            }
        }
        if (this.javaAnnotation == null) {
            HashMap values = new HashMap();
            this.properties.forEach(p -> {
                String name = p.getName();
                try {
                    values.put(name, OgnlUtils.convertValue((Object)p.getValue(), this.javaAnnotationClass.getMethod(name, new Class[0]).getReturnType()));
                }
                catch (NoSuchMethodException e) {
                    logger.warn("Ignoring nonexistent annotation property " + name + " for " + this.javaAnnotationClass);
                }
            });
            try {
                this.javaAnnotation = new AnnotationFactory().make(this.javaAnnotationClass, values);
            }
            catch (Exception e) {
                logger.error("Could not make annotation proxy for " + this.javaAnnotationClass, (Throwable)e);
            }
        }
    }

    protected java.lang.annotation.Annotation createLegacyAnnotation() {
        Constructor<?>[] constructors;
        if (this.values.isEmpty()) {
            return null;
        }
        AnnotationsManager annotationsManager = AnnotationsManager.getManager();
        Class annotationImplClass = annotationsManager.getAnnotationImplementationClass(this.javaAnnotationClass);
        if (annotationImplClass == null) {
            return null;
        }
        for (Constructor<?> candidateConstructor : constructors = annotationImplClass.getConstructors()) {
            Class<?>[] parameterTypes = candidateConstructor.getParameterTypes();
            if (parameterTypes.length != this.values.size()) continue;
            try {
                Object[] castValues = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object value;
                    Class<?> parameterType = parameterTypes[i];
                    String stringValue = this.values.get(i);
                    if (parameterType.isArray()) {
                        value = Util.matchStringArray((String)stringValue);
                    } else if (parameterType.isEnum()) {
                        ?[] enumValues = parameterType.getEnumConstants();
                        value = stringValue;
                        for (Object current : enumValues) {
                            Enum enumValue = (Enum)current;
                            if (!enumValue.name().equals(stringValue)) continue;
                            value = enumValue;
                            break;
                        }
                    } else {
                        value = stringValue;
                    }
                    castValues[i] = OgnlUtils.convertValue((Object)value, parameterType);
                }
                return (java.lang.annotation.Annotation)ReflectionUtil.newInstance(candidateConstructor, (Object[])castValues);
            }
            catch (Throwable e) {
                logger.debug("Failed to use constructor: " + candidateConstructor, e);
            }
        }
        return null;
    }

    @Override
    public void link(Model model, Configuration configuration) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    @XmlAttribute(required=true)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="values")
    @XmlElement(name="value", type=String.class)
    @Deprecated
    public List<String> getValues() {
        return this.values;
    }

    @Deprecated
    public void setValues(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    @JsonProperty(value="properties")
    @XmlElement(name="property", type=Property.class)
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties.clear();
        this.properties.addAll(properties);
    }

    public Class getJavaAnnotationClass() {
        return this.javaAnnotationClass;
    }

    public java.lang.annotation.Annotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public Property getProperty(String name) {
        for (Property property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public void setProperty(String name, String value) {
        Property property = this.getProperty(name);
        if (property == null) {
            property = new Property(name, value);
            this.properties.add(property);
        } else {
            property.setValue(value);
        }
    }
}

