/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model;

import com.manydesigns.portofino.model.InitVisitor;
import com.manydesigns.portofino.model.LinkVisitor;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ResetVisitor;
import com.manydesigns.portofino.model.database.Database;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Model {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final LinkedList<Database> databases = new LinkedList();
    public static final Logger logger = LoggerFactory.getLogger(Model.class);

    public void init(Configuration configuration) {
        for (Database database : this.databases) {
            this.init(database, configuration);
        }
    }

    public void init(ModelObject rootObject, Configuration configuration) {
        new ResetVisitor().visit(rootObject);
        new InitVisitor(this, configuration).visit(rootObject);
        new LinkVisitor(this, configuration).visit(rootObject);
    }

    @XmlElementWrapper(name="databases")
    @XmlElement(name="database", type=Database.class)
    public List<Database> getDatabases() {
        return this.databases;
    }
}

