/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.ForeignKey;
import com.manydesigns.portofino.model.database.JdbcConnectionProvider;
import com.manydesigns.portofino.model.database.JndiConnectionProvider;
import com.manydesigns.portofino.model.database.Schema;
import com.manydesigns.portofino.model.database.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"databaseName", "trueString", "falseString", "connectionProvider", "schemas", "entityMode", "annotations"})
@XmlRootElement
public class Database
implements ModelObject,
Annotated {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected final List<Schema> schemas;
    protected String databaseName;
    protected String trueString = null;
    protected String falseString = null;
    protected String entityMode = null;
    protected ConnectionProvider connectionProvider;
    protected Properties settings;
    protected final List<Annotation> annotations = new ArrayList<Annotation>();
    public static final Logger logger = LoggerFactory.getLogger(Database.class);

    public Database() {
        this.schemas = new ArrayList<Schema>();
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
    }

    public String getQualifiedName() {
        return this.databaseName;
    }

    @Override
    public void reset() {
        for (Annotation a : this.annotations) {
            a.reset();
        }
    }

    @Override
    public void init(Model model, Configuration configuration) {
        if (this.databaseName == null) {
            throw new IllegalStateException("Database name is null");
        }
        if (this.databaseName.contains("/") || this.databaseName.contains("\\")) {
            throw new IllegalStateException("Database name contains slashes or backslashes: " + this.databaseName);
        }
        for (Annotation a : this.annotations) {
            a.init(model, configuration);
        }
    }

    @Override
    public void link(Model model, Configuration configuration) {
        for (Annotation a : this.annotations) {
            a.link(model, configuration);
        }
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (Schema schema : this.schemas) {
            visitor.visit(schema);
        }
    }

    @XmlAttribute(required=true)
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @XmlElementWrapper(name="schemas")
    @XmlElement(name="schema", type=Schema.class)
    public List<Schema> getSchemas() {
        return this.schemas;
    }

    public List<Table> getAllTables() {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Schema schema : this.schemas) {
            for (Table table : schema.getTables()) {
                result.add(table);
            }
        }
        return result;
    }

    public List<Column> getAllColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Schema schema : this.schemas) {
            for (Table table : schema.getTables()) {
                for (Column column : table.getColumns()) {
                    result.add(column);
                }
            }
        }
        return result;
    }

    public List<ForeignKey> getAllForeignKeys() {
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        for (Schema schema : this.schemas) {
            for (Table table : schema.getTables()) {
                for (ForeignKey foreignKey : table.getForeignKeys()) {
                    result.add(foreignKey);
                }
            }
        }
        return result;
    }

    public String toString() {
        return MessageFormat.format("database {0}", this.getQualifiedName());
    }

    @XmlAttribute(required=false)
    public String getTrueString() {
        return this.trueString;
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }

    @XmlAttribute(required=false)
    public String getFalseString() {
        return this.falseString;
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }

    @XmlElements(value={@XmlElement(name="jdbcConnection", type=JdbcConnectionProvider.class), @XmlElement(name="jndiConnection", type=JndiConnectionProvider.class)})
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @XmlAttribute(required=false)
    public String getEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(String entityMode) {
        this.entityMode = entityMode;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public void setSettings(Properties settings) {
        this.settings = settings;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation", type=Annotation.class)
    @NotNull
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }
}

