/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.text.OgnlTextFormat;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatformsRegistry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"driver", "url", "username", "password"})
public class JdbcConnectionProvider
extends ConnectionProvider {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected String driver;
    protected String url;
    protected String username;
    protected String password;
    protected String keyPrefix;
    protected String actualUrl;
    protected String actualUsername;
    protected String actualPassword;

    @Override
    public void init(DatabasePlatformsRegistry databasePlatformsRegistry) {
        this.keyPrefix = "portofino.database." + this.getDatabase().getDatabaseName() + ".";
        this.configuration = databasePlatformsRegistry.getPortofinoConfiguration();
        if (this.url == null || this.url.equals(this.keyPrefix + "url")) {
            this.actualUrl = this.configuration.getString(this.keyPrefix + "url");
            if (this.actualUrl == null) {
                this.status = "error";
                throw new RuntimeException("Invalid connection provider for database " + this.getDatabase().getDatabaseName() + " - no URL specified");
            }
        } else {
            this.actualUrl = this.url;
        }
        this.actualUrl = OgnlTextFormat.format((String)this.actualUrl, null);
        if (this.username == null || this.username.equals(this.keyPrefix + "username")) {
            this.actualUsername = this.configuration.getString(this.keyPrefix + "username");
            if (this.actualUsername == null) {
                this.status = "error";
                throw new RuntimeException("Invalid connection provider for database " + this.getDatabase().getDatabaseName() + " - no username specified");
            }
        } else {
            this.actualUsername = this.username;
        }
        this.actualPassword = this.password == null || this.password.equals(this.keyPrefix + "password") ? this.configuration.getString(this.keyPrefix + "password") : this.password;
        super.init(databasePlatformsRegistry);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format("JDBC connection to URL: {0}", this.actualUrl);
    }

    @Override
    public Connection acquireConnection() throws Exception {
        if (this.driver != null) {
            Class.forName(this.driver);
        }
        return DriverManager.getConnection(this.actualUrl, this.actualUsername, this.actualPassword);
    }

    @XmlAttribute
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @XmlAttribute(required=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlAttribute(required=false)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlAttribute(required=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getActualUrl() {
        return this.actualUrl;
    }

    public void setActualUrl(String url) {
        if (this.url == null || this.url.equals(this.keyPrefix + "url")) {
            this.configuration.setProperty(this.keyPrefix + "url", (Object)url);
        } else {
            this.url = url;
        }
        this.actualUrl = url;
    }

    public String getActualUsername() {
        return this.actualUsername;
    }

    public void setActualUsername(String username) {
        if (this.username == null || this.username.equals(this.keyPrefix + "username")) {
            this.configuration.setProperty(this.keyPrefix + "username", (Object)username);
        } else {
            this.username = username;
        }
        this.actualUsername = username;
    }

    public String getActualPassword() {
        return this.actualPassword;
    }

    public void setActualPassword(String password) {
        if (this.password == null || this.password.equals(this.keyPrefix + "url")) {
            this.configuration.setProperty(this.keyPrefix + "password", (Object)password);
        } else {
            this.password = password;
        }
        this.actualPassword = password;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("driver", (Object)this.driver).append("url", (Object)this.actualUrl).append("username", (Object)this.actualUsername).append("password", (Object)this.actualPassword).toString();
    }
}

