/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.elements.annotations.Required;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.Connection;
import java.text.MessageFormat;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.NONE)
public class JndiConnectionProvider
extends ConnectionProvider {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    private String jndiResource;

    @Override
    public String getDescription() {
        return MessageFormat.format("JNDI data source: {0}", this.jndiResource);
    }

    @Override
    public Connection acquireConnection() throws Exception {
        DataSource ds = this.getDataSource();
        return ds.getConnection();
    }

    public DataSource getDataSource() throws Exception {
        InitialContext ic = new InitialContext();
        return (DataSource)ic.lookup(this.jndiResource);
    }

    @XmlAttribute(required=true)
    @Required
    public String getJndiResource() {
        return this.jndiResource;
    }

    public void setJndiResource(String jndiResource) {
        this.jndiResource = jndiResource;
    }
}

