/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.Generator;
import com.manydesigns.portofino.model.database.IncrementGenerator;
import com.manydesigns.portofino.model.database.PrimaryKey;
import com.manydesigns.portofino.model.database.SequenceGenerator;
import com.manydesigns.portofino.model.database.Table;
import com.manydesigns.portofino.model.database.TableGenerator;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
public class PrimaryKeyColumn
implements ModelObject {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected PrimaryKey primaryKey;
    protected String columnName;
    protected Generator generator;
    protected Column actualColumn;
    public static final Logger logger = LoggerFactory.getLogger(PrimaryKeyColumn.class);

    public PrimaryKeyColumn() {
    }

    public PrimaryKeyColumn(PrimaryKey primaryKey) {
        this();
        this.primaryKey = primaryKey;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.primaryKey = (PrimaryKey)parent;
    }

    @Override
    public void reset() {
        this.actualColumn = null;
    }

    @Override
    public void link(Model model, Configuration configuration) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
    }

    @Override
    public void init(Model model, Configuration configuration) {
        assert (this.primaryKey != null);
        assert (this.columnName != null);
        this.actualColumn = DatabaseLogic.findColumnByName(this.primaryKey.getTable(), this.columnName);
        if (this.actualColumn == null) {
            logger.warn("Cannor wire primary key column '{}' to primary key '{}'", (Object)this.columnName, (Object)this.primaryKey);
        }
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @XmlAttribute(required=true)
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Column getActualColumn() {
        return this.actualColumn;
    }

    public void setActualColumn(Column actualColumn) {
        Table table = this.primaryKey.getTable();
        if (actualColumn.getTable() != table) {
            throw new IllegalArgumentException("Column " + actualColumn.getQualifiedName() + " does not belong to the primary key table " + table.getQualifiedName());
        }
        this.actualColumn = actualColumn;
        this.columnName = actualColumn.columnName;
    }

    @XmlElements(value={@XmlElement(name="sequenceGenerator", type=SequenceGenerator.class), @XmlElement(name="incrementGenerator", type=IncrementGenerator.class), @XmlElement(name="tableGenerator", type=TableGenerator.class)})
    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }
}

