/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.DatabaseLogic;
import com.manydesigns.portofino.model.database.HasReferences;
import com.manydesigns.portofino.model.database.Table;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration2.Configuration;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"fromColumn", "toColumn"})
public class Reference
implements ModelObject {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected HasReferences owner;
    protected String fromColumn;
    protected String toColumn;
    protected Column actualFromColumn;
    protected Column actualToColumn;

    public Reference() {
    }

    public Reference(HasReferences owner) {
        this.owner = owner;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.owner = (HasReferences)parent;
    }

    @Override
    public void reset() {
        this.actualFromColumn = null;
        this.actualToColumn = null;
    }

    @Override
    public void init(Model model, Configuration configuration) {
        assert (this.owner != null);
        assert (this.fromColumn != null);
    }

    @Override
    public void link(Model model, Configuration configuration) {
        this.actualFromColumn = DatabaseLogic.findColumnByName(this.owner.getFromTable(), this.fromColumn);
        if (this.actualFromColumn == null) {
            throw new RuntimeException("Cannot resolve column: " + this.owner.getFromTable().getQualifiedName() + "." + this.fromColumn);
        }
        Table toTable = this.owner.getToTable();
        if (toTable != null) {
            this.actualToColumn = DatabaseLogic.findColumnByName(toTable, this.toColumn);
        }
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
    }

    public HasReferences getOwner() {
        return this.owner;
    }

    public void setOwner(HasReferences owner) {
        this.owner = owner;
    }

    @XmlAttribute(required=true)
    public String getFromColumn() {
        return this.fromColumn;
    }

    public void setFromColumn(String fromColumn) {
        this.fromColumn = fromColumn;
    }

    @XmlAttribute(required=true)
    public String getToColumn() {
        return this.toColumn;
    }

    public void setToColumn(String toColumn) {
        this.toColumn = toColumn;
    }

    public Column getActualFromColumn() {
        return this.actualFromColumn;
    }

    public Column getActualToColumn() {
        return this.actualToColumn;
    }
}

