/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import com.manydesigns.portofino.model.Annotated;
import com.manydesigns.portofino.model.Annotation;
import com.manydesigns.portofino.model.Model;
import com.manydesigns.portofino.model.ModelObject;
import com.manydesigns.portofino.model.ModelObjectVisitor;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.Database;
import com.manydesigns.portofino.model.database.Table;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"catalog", "schemaName", "immediateTables", "annotations"})
public class Schema
implements ModelObject,
Annotated {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    protected Database database;
    protected final List<Table> tables = new ArrayList<Table>();
    @Deprecated
    protected final List<Table> immediateTables;
    protected String schemaName;
    protected String actualSchemaName;
    protected String catalog;
    protected Configuration configuration;
    protected String key;
    protected final List<Annotation> annotations = new ArrayList<Annotation>();
    public static final Logger logger = LoggerFactory.getLogger(Schema.class);

    public Schema() {
        this.immediateTables = new ArrayList<Table>();
    }

    public Schema(Database database) {
        this();
        this.database = database;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.database = (Database)parent;
        this.tables.addAll(this.immediateTables);
        this.immediateTables.clear();
    }

    public String getQualifiedName() {
        String name;
        String string = name = this.actualSchemaName != null ? this.actualSchemaName : this.schemaName;
        if (this.getDatabaseName() == null) {
            return name;
        }
        return MessageFormat.format("{0}.{1}", this.getDatabaseName(), name);
    }

    @Override
    public void reset() {
    }

    @Override
    public void init(Model model, Configuration configuration) {
        assert (this.database != null);
        assert (this.schemaName != null);
        this.configuration = configuration;
        this.key = "portofino.database." + this.getDatabase().getDatabaseName() + ".schemas." + this.schemaName;
        if (this.actualSchemaName == null) {
            this.actualSchemaName = configuration.getString(this.key);
        }
        if (this.actualSchemaName == null) {
            this.actualSchemaName = this.schemaName;
        }
    }

    @Override
    public void link(Model model, Configuration configuration) {
    }

    @Override
    public void visitChildren(ModelObjectVisitor visitor) {
        for (Table table : this.tables) {
            visitor.visit(table);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getDatabaseName() {
        return this.database != null ? this.database.getDatabaseName() : null;
    }

    @XmlAttribute(required=true)
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getActualSchemaName() {
        return this.actualSchemaName;
    }

    public void setActualSchemaName(String actualSchemaName) {
        if (this.key != null) {
            if (StringUtils.isEmpty((String)actualSchemaName)) {
                this.configuration.clearProperty(this.key);
            } else if (this.configuration.containsKey(this.key) || !this.schemaName.equals(actualSchemaName)) {
                this.configuration.setProperty(this.key, (Object)actualSchemaName);
            }
        }
        this.actualSchemaName = actualSchemaName;
    }

    @XmlAttribute
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Deprecated
    @XmlElementWrapper(name="tables")
    @XmlElement(name="table", type=Table.class)
    public List<Table> getImmediateTables() {
        return this.immediateTables;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<Column> getAllColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Table table : this.tables) {
            result.addAll(table.getColumns());
        }
        return result;
    }

    public Table findTableByQualifiedName(String qualifiedTableName) {
        int lastDot = qualifiedTableName.lastIndexOf(".");
        String tableName = qualifiedTableName.substring(lastDot + 1);
        for (Table table : this.tables) {
            if (!table.getTableName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        logger.debug("Table not found: {}", (Object)qualifiedTableName);
        return null;
    }

    public Column findColumnByQualifiedName(String qualifiedColumnName) {
        int lastDot = qualifiedColumnName.lastIndexOf(".");
        String qualifiedTableName = qualifiedColumnName.substring(0, lastDot);
        String columnName = qualifiedColumnName.substring(lastDot + 1);
        Table table = this.findTableByQualifiedName(qualifiedTableName);
        if (table != null) {
            for (Column column : table.getColumns()) {
                if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
                return column;
            }
        }
        logger.debug("Column not found: {}", (Object)qualifiedColumnName);
        return null;
    }

    public String toString() {
        return MessageFormat.format("schema {0}", this.getQualifiedName());
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation", type=Annotation.class)
    @NotNull
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }
}

