/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(Type.class);
    protected final String typeName;
    protected final int jdbcType;
    protected final boolean autoincrement;
    protected final Integer maximumPrecision;
    protected final String literalPrefix;
    protected final String literalSuffix;
    protected final boolean nullable;
    protected final boolean caseSensitive;
    protected final boolean searchable;
    protected final int minimumScale;
    protected final int maximumScale;
    protected final Boolean precisionRequired;
    protected final Boolean scaleRequired;

    public Type(String typeName, int jdbcType, Integer maximumPrecision, String literalPrefix, String literalSuffix, boolean nullable, boolean caseSensitive, boolean searchable, boolean autoincrement, int minimumScale, int maximumScale) {
        this.typeName = typeName;
        this.jdbcType = jdbcType;
        this.maximumPrecision = maximumPrecision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.nullable = nullable;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.autoincrement = autoincrement;
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.precisionRequired = null;
        this.scaleRequired = null;
    }

    public Type(String typeName, int jdbcType, Integer maximumPrecision, String literalPrefix, String literalSuffix, boolean nullable, boolean caseSensitive, boolean searchable, boolean autoincrement, int minimumScale, int maximumScale, boolean precisionRequired, boolean scaleRequired) {
        this.typeName = typeName;
        this.jdbcType = jdbcType;
        this.maximumPrecision = maximumPrecision;
        this.literalPrefix = literalPrefix;
        this.literalSuffix = literalSuffix;
        this.nullable = nullable;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.autoincrement = autoincrement;
        this.minimumScale = minimumScale;
        this.maximumScale = maximumScale;
        this.precisionRequired = precisionRequired;
        this.scaleRequired = scaleRequired;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public Class getDefaultJavaType() {
        return Type.getDefaultJavaType(this.jdbcType, this.typeName, this.maximumPrecision, this.maximumScale);
    }

    @Nullable
    public static Class getDefaultJavaType(int jdbcType, String databaseType, Integer precision, Integer scale) {
        switch (jdbcType) {
            case -5: {
                return Long.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return String.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2: 
            case 3: {
                if (scale != null && scale > 0) {
                    return BigDecimal.class;
                }
                return Type.getDefaultIntegerType(precision);
            }
            case 7: 
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case 4: {
                return Type.getDefaultIntegerType(precision);
            }
            case 5: {
                return Short.class;
            }
            case -6: {
                return Byte.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return byte[].class;
            }
            case 2003: {
                return Array.class;
            }
            case 70: {
                return URL.class;
            }
            case 2000: 
            case 2001: {
                return Object.class;
            }
            case 0: 
            case 2006: {
                return Ref.class;
            }
            case 1111: {
                if ("JSONB".equalsIgnoreCase(databaseType)) {
                    return String.class;
                }
                return Ref.class;
            }
            case 2002: {
                return Struct.class;
            }
        }
        logger.warn("Unsupported jdbc type: {}", (Object)jdbcType);
        return null;
    }

    public static Class<? extends Number> getDefaultIntegerType(Integer precision) {
        if (precision == null) {
            return BigInteger.class;
        }
        if ((double)precision.intValue() < Math.log10(2.147483647E9)) {
            return Integer.class;
        }
        if ((double)precision.intValue() < Math.log10(9.223372036854776E18)) {
            return Long.class;
        }
        if (precision == 131089) {
            return BigDecimal.class;
        }
        return BigInteger.class;
    }

    public Class[] getAvailableJavaTypes(Integer length) {
        if (this.isNumeric()) {
            return new Class[]{Integer.class, Long.class, Byte.class, Short.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, Boolean.class};
        }
        if ("JSONB".equalsIgnoreCase(this.typeName)) {
            return new Class[]{String.class, Map.class, List.class};
        }
        Class defaultJavaType = this.getDefaultJavaType();
        if (defaultJavaType == String.class) {
            if (length != null && length < 256) {
                return new Class[]{String.class, Boolean.class};
            }
            return new Class[]{String.class};
        }
        if (defaultJavaType == Timestamp.class) {
            return new Class[]{Timestamp.class, DateTime.class, Date.class, LocalDateTime.class, ZonedDateTime.class, Instant.class};
        }
        if (defaultJavaType == Date.class) {
            return new Class[]{Date.class, DateTime.class, LocalDate.class, Timestamp.class};
        }
        if (defaultJavaType != null) {
            return new Class[]{defaultJavaType};
        }
        return new Class[]{Object.class};
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public Integer getMaximumPrecision() {
        return this.maximumPrecision;
    }

    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public Integer getMinimumScale() {
        return this.minimumScale;
    }

    public Integer getMaximumScale() {
        return this.maximumScale;
    }

    public String toString() {
        return "Type{typeName='" + this.typeName + '\'' + ", jdbcType=" + this.jdbcType + ", autoincrement=" + this.autoincrement + ", maximumPrecision=" + this.maximumPrecision + ", literalPrefix='" + this.literalPrefix + '\'' + ", literalSuffix='" + this.literalSuffix + '\'' + ", nullable=" + this.nullable + ", caseSensitive=" + this.caseSensitive + ", searchable=" + this.searchable + ", minimumScale=" + this.minimumScale + ", maximumScale=" + this.maximumScale + '}';
    }

    public boolean isPrecisionRequired() {
        if (this.precisionRequired != null) {
            return this.precisionRequired;
        }
        switch (this.jdbcType) {
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean isScaleRequired() {
        if (this.scaleRequired != null) {
            return this.scaleRequired;
        }
        switch (this.jdbcType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this.jdbcType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }
}

