/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database.platforms;

import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.DatabasePlatform;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabasePlatform
implements DatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String[] tableTypes = new String[]{"TABLE"};
    public static final String TABLE_CAT = "TABLE_CAT";
    public static final String TABLE_CATALOG = "TABLE_CATALOG";
    public static final String TABLE_SCHEM = "TABLE_SCHEM";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String KEY_SEQ = "KEY_SEQ";
    public static final String PK_NAME = "PK_NAME";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String NULLABLE = "NULLABLE";
    public static final String COLUMN_SIZE = "COLUMN_SIZE";
    public static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    public static final String FKTABLE_NAME = "FKTABLE_NAME";
    public static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    public static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    public static final String PKTABLE_NAME = "PKTABLE_NAME";
    public static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    public static final String UPDATE_RULE = "UPDATE_RULE";
    public static final String DELETE_RULE = "DELETE_RULE";
    public static final String DEFERRABILITY = "DEFERRABILITY";
    public static final String FK_NAME = "FK_NAME";
    public static final String FKTABLE_CAT = "FKTABLE_CAT";
    public static final String PKTABLE_CAT = "PKTABLE_CAT";
    protected String status;
    protected String hibernateDialect;
    protected String connectionStringTemplate;
    public static final Logger logger = LoggerFactory.getLogger(AbstractDatabasePlatform.class);

    public AbstractDatabasePlatform(String hibernateDialect, String connectionStringTemplate) {
        this.hibernateDialect = hibernateDialect;
        this.connectionStringTemplate = connectionStringTemplate;
        this.status = "created";
    }

    @Override
    public void test() {
        boolean success = DbUtils.loadDriver((String)this.getStandardDriverClassName());
        this.status = success ? "ok" : "driver not found";
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public DatabasePlatform.TypeDescriptor getDatabaseSpecificType(Column column) {
        return null;
    }

    @Override
    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    @Override
    public boolean isDialectAutodetected() {
        return true;
    }

    @Override
    public String getConnectionStringTemplate() {
        return this.connectionStringTemplate;
    }

    @Override
    public void shutdown(ConnectionProvider connectionProvider) {
        logger.info("Shutting down connection provider: {}", (Object)connectionProvider.getDatabase().getDatabaseName());
    }

    @Override
    public List<String[]> getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<String[]> schemaNames = new ArrayList<String[]>();
        try (ResultSet rs = databaseMetaData.getSchemas();){
            while (rs.next()) {
                String schemaName = rs.getString(TABLE_SCHEM);
                String schemaCatalog = rs.getString(this.getCatalogColumnName());
                schemaNames.add(new String[]{schemaCatalog, schemaName});
            }
        }
        return schemaNames;
    }

    protected String getCatalogColumnName() {
        return TABLE_CATALOG;
    }
}

