/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.model.database.platforms;

import com.manydesigns.elements.annotations.Status;
import com.manydesigns.portofino.model.database.Column;
import com.manydesigns.portofino.model.database.ConnectionProvider;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public interface DatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String STATUS_CREATED = "created";
    public static final String STATUS_OK = "ok";
    public static final String STATUS_DRIVER_NOT_FOUND = "driver not found";
    public static final String STATUS_DRIVER_ERROR = "driver error";

    public String getDescription();

    public String getStandardDriverClassName();

    public String getHibernateDialect();

    public boolean isDialectAutodetected();

    public String getConnectionStringTemplate();

    @Status(red={"driver error"}, amber={"created", "driver not found"}, green={"ok"})
    public String getStatus();

    public TypeDescriptor getDatabaseSpecificType(Column var1);

    public void test();

    public boolean isApplicable(ConnectionProvider var1);

    public void shutdown(ConnectionProvider var1);

    public List<String[]> getSchemaNames(DatabaseMetaData var1) throws SQLException;

    public static class TypeDescriptor {
        public final String name;
        public final Properties parameters;

        public TypeDescriptor(String name, Properties parameters) {
            this.name = name;
            this.parameters = parameters;
        }
    }
}

