/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.AbstractDatabasePlatform;
import org.hibernate.dialect.SQLServerDialect;

public class JTDSDatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String DESCRIPTION = "Microsoft SQL Server (jTDS driver)";
    public static final String STANDARD_DRIVER_CLASS_NAME = "net.sourceforge.jtds.jdbc.Driver";

    public JTDSDatabasePlatform() {
        super(SQLServerDialect.class.getName(), "jdbc:jtds:sqlserver://<server>[:<port>][/<database>][;instance=<instance>]");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public void test() {
        super.test();
        if (this.status == "ok") {
            this.checkJdbc4();
        }
    }

    protected void checkJdbc4() {
        try {
            Class.forName("java.sql.NClob");
        }
        catch (ClassNotFoundException e) {
            this.status = "driver error";
        }
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return connectionProvider.getDatabaseProductName().startsWith("Microsoft SQL Server") && connectionProvider.getDriverName().contains("jTDS");
    }
}

