/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.portofino.database.platforms;

import com.manydesigns.portofino.model.database.ConnectionProvider;
import com.manydesigns.portofino.model.database.platforms.AbstractDatabasePlatform;
import org.hibernate.dialect.SQLServerDialect;

public class MSSqlServerDatabasePlatform
extends AbstractDatabasePlatform {
    public static final String copyright = "Copyright (C) 2005-2020 ManyDesigns srl";
    public static final String DESCRIPTION = "Microsoft SQL Server";
    public static final String STANDARD_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    public MSSqlServerDatabasePlatform() {
        super(SQLServerDialect.class.getName(), "jdbc:sqlserver://<host>[:<port>];database=<databaseName>");
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getStandardDriverClassName() {
        return STANDARD_DRIVER_CLASS_NAME;
    }

    public boolean isApplicable(ConnectionProvider connectionProvider) {
        return connectionProvider.getDatabaseProductName().startsWith(DESCRIPTION) && !connectionProvider.getDriverName().contains("jTDS");
    }
}

