/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@UiThread
public class MoveGestureDetector
extends ProgressiveGesture<OnMoveGestureListener> {
    private static final int MOVE_REQUIRED_POINTERS_COUNT = 1;
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private PointF previousFocalPoint;
    private boolean resetFocal;
    float lastDistanceX;
    float lastDistanceY;
    private float moveThreshold;
    private final Map<Integer, MoveDistancesObject> moveDistancesObjectMap = new HashMap<Integer, MoveDistancesObject>();

    public MoveGestureDetector(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: 
            case 5: {
                this.resetFocal = true;
                float x = motionEvent.getX(motionEvent.getActionIndex());
                float y = motionEvent.getY(motionEvent.getActionIndex());
                this.moveDistancesObjectMap.put(motionEvent.getPointerId(motionEvent.getActionIndex()), new MoveDistancesObject(x, y));
                break;
            }
            case 1: {
                this.moveDistancesObjectMap.clear();
                break;
            }
            case 6: {
                this.resetFocal = true;
                this.moveDistancesObjectMap.remove(motionEvent.getPointerId(motionEvent.getActionIndex()));
                break;
            }
            case 3: {
                this.moveDistancesObjectMap.clear();
                break;
            }
        }
        return super.analyzeEvent(motionEvent);
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        this.updateMoveDistancesObjects();
        if (this.isInProgress()) {
            PointF currentFocalPoint = this.getFocalPoint();
            this.lastDistanceX = this.previousFocalPoint.x - currentFocalPoint.x;
            this.lastDistanceY = this.previousFocalPoint.y - currentFocalPoint.y;
            this.previousFocalPoint = currentFocalPoint;
            if (this.resetFocal) {
                this.resetFocal = false;
                return ((OnMoveGestureListener)this.listener).onMove(this, 0.0f, 0.0f);
            }
            return ((OnMoveGestureListener)this.listener).onMove(this, this.lastDistanceX, this.lastDistanceY);
        }
        if (this.canExecute(13) && ((OnMoveGestureListener)this.listener).onMoveBegin(this)) {
            this.gestureStarted();
            this.previousFocalPoint = this.getFocalPoint();
            this.resetFocal = false;
            return true;
        }
        return false;
    }

    private void updateMoveDistancesObjects() {
        Iterator iterator = this.pointerIdList.iterator();
        while (iterator.hasNext()) {
            int pointerId = (Integer)iterator.next();
            this.moveDistancesObjectMap.get(pointerId).addNewPosition(this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(pointerId)), this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(pointerId)));
        }
    }

    boolean checkAnyMoveAboveThreshold() {
        for (MoveDistancesObject moveDistancesObject : this.moveDistancesObjectMap.values()) {
            if (!(Math.abs(moveDistancesObject.getDistanceXSinceStart()) >= this.moveThreshold) && !(Math.abs(moveDistancesObject.getDistanceYSinceStart()) >= this.moveThreshold)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return super.canExecute(invokedGestureType) && this.checkAnyMoveAboveThreshold();
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnMoveGestureListener)this.listener).onMoveEnd(this, this.velocityX, this.velocityY);
    }

    @Override
    protected int getRequiredPointersCount() {
        return 1;
    }

    public float getMoveThreshold() {
        return this.moveThreshold;
    }

    public void setMoveThreshold(float moveThreshold) {
        this.moveThreshold = moveThreshold;
    }

    public void setMoveThresholdResource(@DimenRes int moveThresholdDimen) {
        this.setMoveThreshold(this.context.getResources().getDimension(moveThresholdDimen));
    }

    public float getLastDistanceX() {
        return this.lastDistanceX;
    }

    public float getLastDistanceY() {
        return this.lastDistanceY;
    }

    public MoveDistancesObject getMoveObject(int pointerIndex) {
        if (this.isInProgress() && pointerIndex >= 0 && pointerIndex < this.getPointersCount()) {
            return this.moveDistancesObjectMap.get(this.pointerIdList.get(pointerIndex));
        }
        return null;
    }

    static {
        handledTypes.add(13);
    }

    public static class SimpleOnMoveGestureListener
    implements OnMoveGestureListener {
        @Override
        public boolean onMoveBegin(MoveGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onMove(MoveGestureDetector detector, float distanceX, float distanceY) {
            return false;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector detector, float velocityX, float velocityY) {
        }
    }

    public static interface OnMoveGestureListener {
        public boolean onMoveBegin(MoveGestureDetector var1);

        public boolean onMove(MoveGestureDetector var1, float var2, float var3);

        public void onMoveEnd(MoveGestureDetector var1, float var2, float var3);
    }
}

