/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

@UiThread
public class ShoveGestureDetector
extends ProgressiveGesture<OnShoveGestureListener> {
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private float maxShoveAngle;
    private float pixelDeltaThreshold;
    float deltaPixelsSinceStart;
    float deltaPixelSinceLast;

    public ShoveGestureDetector(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        this.deltaPixelSinceLast = this.calculateDeltaPixelsSinceLast();
        this.deltaPixelsSinceStart += this.deltaPixelSinceLast;
        if (this.isInProgress() && this.deltaPixelSinceLast != 0.0f) {
            return ((OnShoveGestureListener)this.listener).onShove(this, this.deltaPixelSinceLast, this.deltaPixelsSinceStart);
        }
        if (this.canExecute(3) && ((OnShoveGestureListener)this.listener).onShoveBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return Math.abs(this.deltaPixelsSinceStart) >= this.pixelDeltaThreshold && super.canExecute(invokedGestureType);
    }

    @Override
    protected boolean isSloppyGesture() {
        return super.isSloppyGesture() || !this.isAngleAcceptable();
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnShoveGestureListener)this.listener).onShoveEnd(this, this.velocityX, this.velocityY);
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaPixelsSinceStart = 0.0f;
    }

    boolean isAngleAcceptable() {
        MultiFingerDistancesObject distancesObject = (MultiFingerDistancesObject)this.pointersDistanceMap.get((Object)new PointerDistancePair((Integer)this.pointerIdList.get(0), (Integer)this.pointerIdList.get(1)));
        double angle = Math.toDegrees(Math.abs(Math.atan2(distancesObject.getCurrFingersDiffY(), distancesObject.getCurrFingersDiffX())));
        return angle <= (double)this.maxShoveAngle || 180.0 - angle <= (double)this.maxShoveAngle;
    }

    float calculateDeltaPixelsSinceLast() {
        float py0 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue()));
        float py1 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()));
        float prevAverageY = (py0 + py1) / 2.0f;
        float cy0 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue()));
        float cy1 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()));
        float currAverageY = (cy0 + cy1) / 2.0f;
        return currAverageY - prevAverageY;
    }

    public float getDeltaPixelsSinceStart() {
        return this.deltaPixelsSinceStart;
    }

    public float getDeltaPixelSinceLast() {
        return this.deltaPixelSinceLast;
    }

    public float getPixelDeltaThreshold() {
        return this.pixelDeltaThreshold;
    }

    public void setPixelDeltaThreshold(float pixelDeltaThreshold) {
        this.pixelDeltaThreshold = pixelDeltaThreshold;
    }

    public void setPixelDeltaThresholdResource(@DimenRes int pixelDeltaThresholdDimen) {
        this.setPixelDeltaThreshold(this.context.getResources().getDimension(pixelDeltaThresholdDimen));
    }

    public float getMaxShoveAngle() {
        return this.maxShoveAngle;
    }

    public void setMaxShoveAngle(float maxShoveAngle) {
        this.maxShoveAngle = maxShoveAngle;
    }

    static {
        handledTypes.add(3);
    }

    public static class SimpleOnShoveGestureListener
    implements OnShoveGestureListener {
        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector, float deltaPixelsSinceLast, float deltaPixelsSinceStart) {
            return false;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector, float velocityX, float velocityY) {
        }
    }

    public static interface OnShoveGestureListener {
        public boolean onShoveBegin(ShoveGestureDetector var1);

        public boolean onShove(ShoveGestureDetector var1, float var2, float var3);

        public void onShoveEnd(ShoveGestureDetector var1, float var2, float var3);
    }
}

