/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

@UiThread
public class RotateGestureDetector
extends ProgressiveGesture<OnRotateGestureListener> {
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private float angleThreshold;
    float deltaSinceStart;
    float deltaSinceLast;

    public RotateGestureDetector(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        this.deltaSinceLast = this.getRotationDegreesSinceLast();
        this.deltaSinceStart += this.deltaSinceLast;
        if (this.isInProgress() && this.deltaSinceLast != 0.0f) {
            return ((OnRotateGestureListener)this.listener).onRotate(this, this.deltaSinceLast, this.deltaSinceStart);
        }
        if (this.canExecute(2) && ((OnRotateGestureListener)this.listener).onRotateBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return Math.abs(this.deltaSinceStart) >= this.angleThreshold && super.canExecute(invokedGestureType);
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        if (this.deltaSinceLast == 0.0f) {
            this.velocityX = 0.0f;
            this.velocityY = 0.0f;
        }
        float angularVelocity = this.calculateAngularVelocityVector(this.velocityX, this.velocityY);
        ((OnRotateGestureListener)this.listener).onRotateEnd(this, this.velocityX, this.velocityY, angularVelocity);
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaSinceStart = 0.0f;
    }

    float getRotationDegreesSinceLast() {
        MultiFingerDistancesObject distancesObject = (MultiFingerDistancesObject)this.pointersDistanceMap.get((Object)new PointerDistancePair((Integer)this.pointerIdList.get(0), (Integer)this.pointerIdList.get(1)));
        double diffRadians = Math.atan2(distancesObject.getPrevFingersDiffY(), distancesObject.getPrevFingersDiffX()) - Math.atan2(distancesObject.getCurrFingersDiffY(), distancesObject.getCurrFingersDiffX());
        return (float)Math.toDegrees(diffRadians);
    }

    float calculateAngularVelocityVector(float velocityX, float velocityY) {
        float angularVelocity = Math.abs((float)((double)(this.getFocalPoint().x * velocityY + this.getFocalPoint().y * velocityX) / (Math.pow(this.getFocalPoint().x, 2.0) + Math.pow(this.getFocalPoint().y, 2.0))));
        if (this.deltaSinceLast < 0.0f) {
            angularVelocity = -angularVelocity;
        }
        return angularVelocity;
    }

    public float getDeltaSinceStart() {
        return this.deltaSinceStart;
    }

    public float getDeltaSinceLast() {
        return this.deltaSinceLast;
    }

    public float getAngleThreshold() {
        return this.angleThreshold;
    }

    public void setAngleThreshold(float angleThreshold) {
        this.angleThreshold = angleThreshold;
    }

    static {
        handledTypes.add(2);
    }

    public static class SimpleOnRotateGestureListener
    implements OnRotateGestureListener {
        @Override
        public boolean onRotateBegin(@NonNull RotateGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onRotate(@NonNull RotateGestureDetector detector, float rotationDegreesSinceLast, float rotationDegreesSinceFirst) {
            return true;
        }

        @Override
        public void onRotateEnd(@NonNull RotateGestureDetector detector, float velocityX, float velocityY, float angularVelocity) {
        }
    }

    public static interface OnRotateGestureListener {
        public boolean onRotateBegin(@NonNull RotateGestureDetector var1);

        public boolean onRotate(@NonNull RotateGestureDetector var1, float var2, float var3);

        public void onRotateEnd(@NonNull RotateGestureDetector var1, float var2, float var3, float var4);
    }
}

