/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import androidx.annotation.DimenRes;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

@UiThread
public class SidewaysShoveGestureDetector
extends ProgressiveGesture<OnSidewaysShoveGestureListener> {
    private static final Set<Integer> handledTypes = new HashSet<Integer>();
    private float maxShoveAngle;
    private float pixelDeltaThreshold;
    float deltaPixelsSinceStart;
    float deltaPixelSinceLast;

    public SidewaysShoveGestureDetector(Context context, AndroidGesturesManager gesturesManager) {
        super(context, gesturesManager);
    }

    @Override
    @NonNull
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected boolean analyzeMovement() {
        super.analyzeMovement();
        this.deltaPixelSinceLast = this.calculateDeltaPixelsSinceLast();
        this.deltaPixelsSinceStart += this.deltaPixelSinceLast;
        if (this.isInProgress() && this.deltaPixelSinceLast != 0.0f) {
            return ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShove(this, this.deltaPixelSinceLast, this.deltaPixelsSinceStart);
        }
        if (this.canExecute(14) && ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShoveBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExecute(int invokedGestureType) {
        return Math.abs(this.deltaPixelsSinceStart) >= this.pixelDeltaThreshold && super.canExecute(invokedGestureType);
    }

    @Override
    protected boolean isSloppyGesture() {
        return super.isSloppyGesture() || !this.isAngleAcceptable();
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShoveEnd(this, this.velocityX, this.velocityY);
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaPixelsSinceStart = 0.0f;
    }

    boolean isAngleAcceptable() {
        MultiFingerDistancesObject distancesObject = (MultiFingerDistancesObject)this.pointersDistanceMap.get((Object)new PointerDistancePair((Integer)this.pointerIdList.get(0), (Integer)this.pointerIdList.get(1)));
        double angle = Math.toDegrees(Math.abs(Math.atan2(distancesObject.getCurrFingersDiffY(), distancesObject.getCurrFingersDiffX())));
        return (angle = Math.abs(angle - 90.0)) <= (double)this.maxShoveAngle;
    }

    float calculateDeltaPixelsSinceLast() {
        float px0 = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue()));
        float px1 = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()));
        float prevAverageX = (px0 + px1) / 2.0f;
        float cx0 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue()));
        float cx1 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()));
        float currAverageX = (cx0 + cx1) / 2.0f;
        return currAverageX - prevAverageX;
    }

    public float getDeltaPixelsSinceStart() {
        return this.deltaPixelsSinceStart;
    }

    public float getDeltaPixelSinceLast() {
        return this.deltaPixelSinceLast;
    }

    public float getPixelDeltaThreshold() {
        return this.pixelDeltaThreshold;
    }

    public void setPixelDeltaThreshold(float pixelDeltaThreshold) {
        this.pixelDeltaThreshold = pixelDeltaThreshold;
    }

    public void setPixelDeltaThresholdResource(@DimenRes int pixelDeltaThresholdDimen) {
        this.setPixelDeltaThreshold(this.context.getResources().getDimension(pixelDeltaThresholdDimen));
    }

    public float getMaxShoveAngle() {
        return this.maxShoveAngle;
    }

    public void setMaxShoveAngle(float maxShoveAngle) {
        this.maxShoveAngle = maxShoveAngle;
    }

    static {
        handledTypes.add(14);
    }

    public static class SimpleOnSidewaysShoveGestureListener
    implements OnSidewaysShoveGestureListener {
        @Override
        public boolean onSidewaysShoveBegin(@NonNull SidewaysShoveGestureDetector detector) {
            return true;
        }

        @Override
        public boolean onSidewaysShove(@NonNull SidewaysShoveGestureDetector detector, float deltaPixelsSinceLast, float deltaPixelsSinceStart) {
            return false;
        }

        @Override
        public void onSidewaysShoveEnd(@NonNull SidewaysShoveGestureDetector detector, float velocityX, float velocityY) {
        }
    }

    public static interface OnSidewaysShoveGestureListener {
        public boolean onSidewaysShoveBegin(@NonNull SidewaysShoveGestureDetector var1);

        public boolean onSidewaysShove(@NonNull SidewaysShoveGestureDetector var1, float var2, float var3);

        public void onSidewaysShoveEnd(@NonNull SidewaysShoveGestureDetector var1, float var2, float var3);
    }
}

