/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.core.view.GestureDetectorCompat;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.BaseGesture;

@UiThread
public class StandardGestureDetector
extends BaseGesture<StandardOnGestureListener> {
    private final GestureDetectorCompat gestureDetector;
    final StandardOnGestureListener innerListener = new StandardOnGestureListener(){

        public boolean onSingleTapUp(MotionEvent e) {
            return StandardGestureDetector.this.canExecute(5) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onSingleTapUp(e);
        }

        public void onLongPress(MotionEvent e) {
            if (StandardGestureDetector.this.canExecute(6)) {
                ((StandardOnGestureListener)StandardGestureDetector.this.listener).onLongPress(e);
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return StandardGestureDetector.this.canExecute(0) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return StandardGestureDetector.this.canExecute(7) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onFling(e1, e2, velocityX, velocityY);
        }

        public void onShowPress(MotionEvent e) {
            if (StandardGestureDetector.this.canExecute(8)) {
                ((StandardOnGestureListener)StandardGestureDetector.this.listener).onShowPress(e);
            }
        }

        public boolean onDown(MotionEvent e) {
            return StandardGestureDetector.this.canExecute(9) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onDown(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            return StandardGestureDetector.this.canExecute(10) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onDoubleTap(e);
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return StandardGestureDetector.this.canExecute(11) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onDoubleTapEvent(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return StandardGestureDetector.this.canExecute(12) && ((StandardOnGestureListener)StandardGestureDetector.this.listener).onSingleTapConfirmed(e);
        }
    };

    public StandardGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.innerListener);
    }

    @Override
    protected boolean analyzeEvent(@NonNull MotionEvent motionEvent) {
        return this.gestureDetector.onTouchEvent(motionEvent);
    }

    public boolean isLongpressEnabled() {
        return this.gestureDetector.isLongpressEnabled();
    }

    public void setIsLongpressEnabled(boolean enabled) {
        this.gestureDetector.setIsLongpressEnabled(enabled);
    }

    public static class SimpleStandardOnGestureListener
    implements StandardOnGestureListener {
        public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
            return false;
        }

        public boolean onDoubleTap(@NonNull MotionEvent e) {
            return false;
        }

        public boolean onDoubleTapEvent(@NonNull MotionEvent e) {
            return false;
        }

        public boolean onDown(@NonNull MotionEvent e) {
            return false;
        }

        public void onShowPress(@NonNull MotionEvent e) {
        }

        public boolean onSingleTapUp(@NonNull MotionEvent e) {
            return false;
        }

        public boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        public void onLongPress(@NonNull MotionEvent e) {
        }

        public boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    }

    public static interface StandardOnGestureListener
    extends GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener {
    }
}

