/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.maps.Projection;

public abstract class Annotation<T extends Geometry> {
    static final String ID_KEY = "id";
    protected JsonObject jsonObject;
    protected T geometry;
    private boolean isDraggable;

    Annotation(long id, JsonObject jsonObject, T geometry) {
        this.jsonObject = jsonObject;
        this.jsonObject.addProperty(ID_KEY, (Number)id);
        this.geometry = geometry;
    }

    public void setGeometry(T geometry) {
        this.geometry = geometry;
    }

    public T getGeometry() {
        if (this.geometry == null) {
            throw new IllegalStateException();
        }
        return this.geometry;
    }

    public long getId() {
        return this.jsonObject.get(ID_KEY).getAsLong();
    }

    JsonObject getFeature() {
        return this.jsonObject;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public void setDraggable(boolean draggable) {
        this.isDraggable = draggable;
    }

    @Nullable
    abstract Geometry getOffsetGeometry(@NonNull Projection var1, @NonNull MoveDistancesObject var2, float var3, float var4);

    abstract void setUsedDataDrivenProperties();

    abstract String getName();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation that = (Annotation)o;
        if (this.isDraggable != that.isDraggable) {
            return false;
        }
        if (!this.jsonObject.equals((Object)that.jsonObject)) {
            return false;
        }
        return this.geometry.equals(that.geometry);
    }

    public int hashCode() {
        int result = this.jsonObject.hashCode();
        result = 31 * result + this.geometry.hashCode();
        result = 31 * result + (this.isDraggable ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getName() + "{geometry=" + this.geometry + ", properties=" + this.jsonObject + ", isDraggable=" + this.isDraggable + '}';
    }
}

