/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationLongClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AnnotationManager<L extends Layer, T extends Annotation, S extends Options<T>, D extends OnAnnotationDragListener<T>, U extends OnAnnotationClickListener<T>, V extends OnAnnotationLongClickListener<T>> {
    private static final String TAG = "AnnotationManager";
    protected final MapboxMap mapboxMap;
    protected final LongSparseArray<T> annotations = new LongSparseArray();
    final Map<String, Boolean> dataDrivenPropertyUsageMap = new HashMap<String, Boolean>();
    final Map<String, PropertyValue> constantPropertyUsageMap = new HashMap<String, PropertyValue>();
    Expression layerFilter;
    private final DraggableAnnotationController<T, D> draggableAnnotationController;
    private final List<D> dragListeners = new ArrayList<D>();
    private final List<U> clickListeners = new ArrayList<U>();
    private final List<V> longClickListeners = new ArrayList<V>();
    private long currentId;
    protected L layer;
    private GeoJsonSource geoJsonSource;
    private final MapClickResolver mapClickResolver;
    private final Comparator<Feature> comparator;
    private Style style;
    private String belowLayerId;
    private CoreElementProvider<L> coreElementProvider;

    @UiThread
    protected AnnotationManager(MapView mapView, MapboxMap mapboxMap, Style style, CoreElementProvider<L> coreElementProvider, Comparator<Feature> comparator, DraggableAnnotationController<T, D> draggableAnnotationController, String belowLayerId, GeoJsonOptions geoJsonOptions) {
        this.mapboxMap = mapboxMap;
        this.comparator = comparator;
        this.style = style;
        this.belowLayerId = belowLayerId;
        this.coreElementProvider = coreElementProvider;
        if (!style.isFullyLoaded()) {
            throw new RuntimeException("The style has to be non-null and fully loaded.");
        }
        this.mapClickResolver = new MapClickResolver();
        mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)this.mapClickResolver);
        mapboxMap.addOnMapLongClickListener((MapboxMap.OnMapLongClickListener)this.mapClickResolver);
        this.draggableAnnotationController = draggableAnnotationController;
        draggableAnnotationController.injectAnnotationManager(this);
        this.initializeSourcesAndLayers(geoJsonOptions);
        mapView.addOnDidFinishLoadingStyleListener(() -> mapboxMap.getStyle(loadedStyle -> {
            this.style = loadedStyle;
            this.initializeSourcesAndLayers(geoJsonOptions);
        }));
    }

    @UiThread
    public LongSparseArray<T> getAnnotations() {
        return this.annotations;
    }

    @UiThread
    public T create(S options) {
        Object t = ((Options)options).build(this.currentId, this);
        this.annotations.put(((Annotation)t).getId(), t);
        ++this.currentId;
        this.updateSource();
        return t;
    }

    @UiThread
    public List<T> create(List<S> optionsList) {
        ArrayList annotationList = new ArrayList();
        for (Options options : optionsList) {
            Object annotation = options.build(this.currentId, this);
            annotationList.add(annotation);
            this.annotations.put(((Annotation)annotation).getId(), annotation);
            ++this.currentId;
        }
        this.updateSource();
        return annotationList;
    }

    @UiThread
    public void delete(T annotation) {
        this.annotations.remove(((Annotation)annotation).getId());
        this.updateSource();
    }

    @UiThread
    public void delete(List<T> annotationList) {
        for (Annotation annotation : annotationList) {
            this.annotations.remove(annotation.getId());
        }
        this.updateSource();
    }

    @UiThread
    public void deleteAll() {
        this.annotations.clear();
        this.updateSource();
    }

    @UiThread
    public void update(T annotation) {
        if (this.annotations.containsValue(annotation)) {
            this.annotations.put(((Annotation)annotation).getId(), annotation);
            this.updateSource();
        } else {
            Logger.e((String)TAG, (String)("Can't update annotation: " + ((Annotation)annotation).toString() + ", the annotation isn't active annotation."));
        }
    }

    @UiThread
    public void update(List<T> annotationList) {
        for (Annotation annotation : annotationList) {
            this.annotations.put(annotation.getId(), (Object)annotation);
        }
        this.updateSource();
    }

    public void updateSource() {
        this.draggableAnnotationController.onSourceUpdated();
        this.internalUpdateSource();
    }

    void internalUpdateSource() {
        if (!this.style.isFullyLoaded()) {
            return;
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation t = (Annotation)this.annotations.valueAt(i);
            features.add(Feature.fromGeometry(t.getGeometry(), (JsonObject)t.getFeature()));
            t.setUsedDataDrivenProperties();
        }
        if (this.comparator != null) {
            Collections.sort(features, this.comparator);
        }
        this.geoJsonSource.setGeoJson(FeatureCollection.fromFeatures(features));
    }

    void enableDataDrivenProperty(@NonNull String property) {
        if (this.dataDrivenPropertyUsageMap.get(property).equals(false)) {
            this.dataDrivenPropertyUsageMap.put(property, true);
            this.setDataDrivenPropertyIsUsed(property);
        }
    }

    protected abstract void setDataDrivenPropertyIsUsed(@NonNull String var1);

    @UiThread
    public void addDragListener(@NonNull D d) {
        this.dragListeners.add(d);
    }

    @UiThread
    public void removeDragListener(@NonNull D d) {
        this.dragListeners.remove(d);
    }

    @UiThread
    public void addClickListener(@NonNull U u) {
        this.clickListeners.add(u);
    }

    @UiThread
    public void removeClickListener(@NonNull U u) {
        this.clickListeners.remove(u);
    }

    @UiThread
    public void addLongClickListener(@NonNull V v) {
        this.longClickListeners.add(v);
    }

    @UiThread
    public void removeLongClickListener(@NonNull V v) {
        this.longClickListeners.remove(v);
    }

    @VisibleForTesting
    List<U> getClickListeners() {
        return this.clickListeners;
    }

    @VisibleForTesting
    List<V> getLongClickListeners() {
        return this.longClickListeners;
    }

    List<D> getDragListeners() {
        return this.dragListeners;
    }

    @UiThread
    public void onDestroy() {
        this.mapboxMap.removeOnMapClickListener((MapboxMap.OnMapClickListener)this.mapClickResolver);
        this.mapboxMap.removeOnMapLongClickListener((MapboxMap.OnMapLongClickListener)this.mapClickResolver);
        this.dragListeners.clear();
        this.clickListeners.clear();
        this.longClickListeners.clear();
    }

    abstract String getAnnotationLayerId();

    abstract String getAnnotationIdKey();

    abstract void initializeDataDrivenPropertyMap();

    abstract void setFilter(@NonNull Expression var1);

    private void initializeSourcesAndLayers(GeoJsonOptions geoJsonOptions) {
        this.geoJsonSource = this.coreElementProvider.getSource(geoJsonOptions);
        this.layer = this.coreElementProvider.getLayer();
        this.style.addSource((Source)this.geoJsonSource);
        if (this.belowLayerId == null) {
            this.style.addLayer(this.layer);
        } else {
            this.style.addLayerBelow(this.layer, this.belowLayerId);
        }
        this.initializeDataDrivenPropertyMap();
        this.layer.setProperties(this.constantPropertyUsageMap.values().toArray(new PropertyValue[0]));
        if (this.layerFilter != null) {
            this.setFilter(this.layerFilter);
        }
        this.updateSource();
    }

    @Nullable
    private T queryMapForFeatures(@NonNull LatLng point) {
        return this.queryMapForFeatures(this.mapboxMap.getProjection().toScreenLocation(point));
    }

    @Nullable
    T queryMapForFeatures(@NonNull PointF point) {
        List features = this.mapboxMap.queryRenderedFeatures(point, new String[]{this.getAnnotationLayerId()});
        if (!features.isEmpty()) {
            long id = ((Feature)features.get(0)).getProperty(this.getAnnotationIdKey()).getAsLong();
            return (T)((Annotation)this.annotations.get(id));
        }
        return null;
    }

    private class MapClickResolver
    implements MapboxMap.OnMapClickListener,
    MapboxMap.OnMapLongClickListener {
        private MapClickResolver() {
        }

        public boolean onMapClick(@NonNull LatLng point) {
            if (AnnotationManager.this.clickListeners.isEmpty()) {
                return false;
            }
            Annotation annotation = AnnotationManager.this.queryMapForFeatures(point);
            if (annotation != null) {
                for (OnAnnotationClickListener clickListener : AnnotationManager.this.clickListeners) {
                    clickListener.onAnnotationClick(annotation);
                }
            }
            return false;
        }

        public boolean onMapLongClick(@NonNull LatLng point) {
            if (AnnotationManager.this.longClickListeners.isEmpty()) {
                return false;
            }
            Annotation annotation = AnnotationManager.this.queryMapForFeatures(point);
            if (annotation != null) {
                for (OnAnnotationLongClickListener clickListener : AnnotationManager.this.longClickListeners) {
                    clickListener.onAnnotationLongClick(annotation);
                }
            }
            return false;
        }
    }
}

