/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class Circle
extends Annotation<Point> {
    private final AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager;

    Circle(long id, AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Point geometry) {
        super(id, jsonObject, geometry);
        this.annotationManager = annotationManager;
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("circle-radius") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-radius");
        }
        if (!(this.jsonObject.get("circle-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-color");
        }
        if (!(this.jsonObject.get("circle-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-blur");
        }
        if (!(this.jsonObject.get("circle-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-opacity");
        }
        if (!(this.jsonObject.get("circle-stroke-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-width");
        }
        if (!(this.jsonObject.get("circle-stroke-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-color");
        }
        if (!(this.jsonObject.get("circle-stroke-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("circle-stroke-opacity");
        }
    }

    public void setLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
    }

    @NonNull
    public LatLng getLatLng() {
        return new LatLng(((Point)this.geometry).latitude(), ((Point)this.geometry).longitude());
    }

    public Float getCircleRadius() {
        return Float.valueOf(this.jsonObject.get("circle-radius").getAsFloat());
    }

    public void setCircleRadius(Float value) {
        this.jsonObject.addProperty("circle-radius", (Number)value);
    }

    @ColorInt
    public int getCircleColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("circle-color").getAsString());
    }

    public String getCircleColor() {
        return this.jsonObject.get("circle-color").getAsString();
    }

    public void setCircleColor(@ColorInt int color) {
        this.jsonObject.addProperty("circle-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setCircleColor(@NonNull String color) {
        this.jsonObject.addProperty("circle-color", color);
    }

    public Float getCircleBlur() {
        return Float.valueOf(this.jsonObject.get("circle-blur").getAsFloat());
    }

    public void setCircleBlur(Float value) {
        this.jsonObject.addProperty("circle-blur", (Number)value);
    }

    public Float getCircleOpacity() {
        return Float.valueOf(this.jsonObject.get("circle-opacity").getAsFloat());
    }

    public void setCircleOpacity(Float value) {
        this.jsonObject.addProperty("circle-opacity", (Number)value);
    }

    public Float getCircleStrokeWidth() {
        return Float.valueOf(this.jsonObject.get("circle-stroke-width").getAsFloat());
    }

    public void setCircleStrokeWidth(Float value) {
        this.jsonObject.addProperty("circle-stroke-width", (Number)value);
    }

    @ColorInt
    public int getCircleStrokeColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("circle-stroke-color").getAsString());
    }

    public String getCircleStrokeColor() {
        return this.jsonObject.get("circle-stroke-color").getAsString();
    }

    public void setCircleStrokeColor(@ColorInt int color) {
        this.jsonObject.addProperty("circle-stroke-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setCircleStrokeColor(@NonNull String color) {
        this.jsonObject.addProperty("circle-stroke-color", color);
    }

    public Float getCircleStrokeOpacity() {
        return Float.valueOf(this.jsonObject.get("circle-stroke-opacity").getAsFloat());
    }

    public void setCircleStrokeOpacity(Float value) {
        this.jsonObject.addProperty("circle-stroke-opacity", (Number)value);
    }

    @Override
    @Nullable
    Geometry getOffsetGeometry(@NonNull Projection projection, @NonNull MoveDistancesObject moveDistancesObject, float touchAreaShiftX, float touchAreaShiftY) {
        PointF pointF = new PointF(moveDistancesObject.getCurrentX() - touchAreaShiftX, moveDistancesObject.getCurrentY() - touchAreaShiftY);
        LatLng latLng = projection.fromScreenLocation(pointF);
        if (latLng.getLatitude() > 85.05112877980659 || latLng.getLatitude() < -85.05112877980659) {
            return null;
        }
        return Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
    }

    @Override
    String getName() {
        return "Circle";
    }
}

