/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Circle;
import com.mapbox.mapboxsdk.plugins.annotation.CircleOptions;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnCircleLongClickListener;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.List;

public class CircleManager
extends AnnotationManager<CircleLayer, Circle, CircleOptions, OnCircleDragListener, OnCircleClickListener, OnCircleLongClickListener> {
    public static final String ID_GEOJSON_SOURCE = "mapbox-android-circle-source";
    public static final String ID_GEOJSON_LAYER = "mapbox-android-circle-layer";
    private static final String PROPERTY_circleTranslate = "circle-translate";
    private static final String PROPERTY_circleTranslateAnchor = "circle-translate-anchor";
    private static final String PROPERTY_circlePitchScale = "circle-pitch-scale";
    private static final String PROPERTY_circlePitchAlignment = "circle-pitch-alignment";

    @UiThread
    public CircleManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style) {
        this(mapView, mapboxMap, style, null, null);
    }

    @UiThread
    public CircleManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId) {
        this(mapView, mapboxMap, style, belowLayerId, null);
    }

    @UiThread
    public CircleManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId, @Nullable GeoJsonOptions geoJsonOptions) {
        this(mapView, mapboxMap, style, new CoreElementProvider<CircleLayer>(){

            @Override
            public CircleLayer getLayer() {
                return new CircleLayer(CircleManager.ID_GEOJSON_LAYER, CircleManager.ID_GEOJSON_SOURCE);
            }

            @Override
            public GeoJsonSource getSource(@Nullable GeoJsonOptions geoJsonOptions) {
                if (geoJsonOptions != null) {
                    return new GeoJsonSource(CircleManager.ID_GEOJSON_SOURCE, geoJsonOptions);
                }
                return new GeoJsonSource(CircleManager.ID_GEOJSON_SOURCE);
            }
        }, belowLayerId, geoJsonOptions, new DraggableAnnotationController<Circle, OnCircleDragListener>(mapView, mapboxMap));
    }

    @VisibleForTesting
    CircleManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @NonNull CoreElementProvider<CircleLayer> coreElementProvider, @Nullable String belowLayerId, @Nullable GeoJsonOptions geoJsonOptions, DraggableAnnotationController<Circle, OnCircleDragListener> draggableAnnotationController) {
        super(mapView, mapboxMap, style, coreElementProvider, null, draggableAnnotationController, belowLayerId, geoJsonOptions);
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        this.dataDrivenPropertyUsageMap.put("circle-radius", false);
        this.dataDrivenPropertyUsageMap.put("circle-color", false);
        this.dataDrivenPropertyUsageMap.put("circle-blur", false);
        this.dataDrivenPropertyUsageMap.put("circle-opacity", false);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-width", false);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-color", false);
        this.dataDrivenPropertyUsageMap.put("circle-stroke-opacity", false);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(@NonNull String property) {
        switch (property) {
            case "circle-radius": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleRadius((Expression)Expression.get((String)"circle-radius"))});
                break;
            }
            case "circle-color": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleColor((Expression)Expression.get((String)"circle-color"))});
                break;
            }
            case "circle-blur": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleBlur((Expression)Expression.get((String)"circle-blur"))});
                break;
            }
            case "circle-opacity": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleOpacity((Expression)Expression.get((String)"circle-opacity"))});
                break;
            }
            case "circle-stroke-width": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleStrokeWidth((Expression)Expression.get((String)"circle-stroke-width"))});
                break;
            }
            case "circle-stroke-color": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleStrokeColor((Expression)Expression.get((String)"circle-stroke-color"))});
                break;
            }
            case "circle-stroke-opacity": {
                ((CircleLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.circleStrokeOpacity((Expression)Expression.get((String)"circle-stroke-opacity"))});
            }
        }
    }

    @Override
    @UiThread
    public List<Circle> create(@NonNull String json) {
        return this.create(FeatureCollection.fromJson((String)json));
    }

    @Override
    @UiThread
    public List<Circle> create(@NonNull FeatureCollection featureCollection) {
        List features = featureCollection.features();
        ArrayList<CircleOptions> options = new ArrayList<CircleOptions>();
        if (features != null) {
            for (Feature feature : features) {
                CircleOptions option = CircleOptions.fromFeature(feature);
                if (option == null) continue;
                options.add(option);
            }
        }
        return this.create(options);
    }

    @Override
    String getAnnotationLayerId() {
        return ID_GEOJSON_LAYER;
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public Float[] getCircleTranslate() {
        return (Float[])((CircleLayer)this.layer).getCircleTranslate().value;
    }

    public void setCircleTranslate(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.circleTranslate((Float[])value);
        this.constantPropertyUsageMap.put(PROPERTY_circleTranslate, propertyValue);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getCircleTranslateAnchor() {
        return (String)((CircleLayer)this.layer).getCircleTranslateAnchor().value;
    }

    public void setCircleTranslateAnchor(String value) {
        PropertyValue propertyValue = PropertyFactory.circleTranslateAnchor((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_circleTranslateAnchor, propertyValue);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getCirclePitchScale() {
        return (String)((CircleLayer)this.layer).getCirclePitchScale().value;
    }

    public void setCirclePitchScale(String value) {
        PropertyValue propertyValue = PropertyFactory.circlePitchScale((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_circlePitchScale, propertyValue);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getCirclePitchAlignment() {
        return (String)((CircleLayer)this.layer).getCirclePitchAlignment().value;
    }

    public void setCirclePitchAlignment(String value) {
        PropertyValue propertyValue = PropertyFactory.circlePitchAlignment((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_circlePitchAlignment, propertyValue);
        ((CircleLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    @Override
    public void setFilter(@NonNull Expression expression) {
        this.layerFilter = expression;
        ((CircleLayer)this.layer).setFilter(this.layerFilter);
    }

    @Nullable
    public Expression getFilter() {
        return ((CircleLayer)this.layer).getFilter();
    }
}

